/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDeploymentImpl<D extends DeploymentConfiguration>
extends DeploymentImpl<D> {
    private final ServerRuntimeInstance<D> myServerInstance;
    private DeploymentImpl myRemoteDeployment;

    public LocalDeploymentImpl(@NotNull ServerRuntimeInstance<D> instance, @NotNull ServerConnectionImpl<D> connection, @NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime, @NotNull DeploymentTask<D> deploymentTask) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl", "<init>"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl", "<init>"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl", "<init>"));
        }
        if (deploymentTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentTask", "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl", "<init>"));
        }
        super(connection, instance.getDeploymentName(deploymentTask.getSource(), deploymentTask.getConfiguration()), status, statusText, runtime, deploymentTask, instance.getDeploymentGroup(deploymentTask.getSource(), deploymentTask.getConfiguration()));
        this.myServerInstance = instance;
    }

    public void setRemoteDeployment(DeploymentImpl remoteDeployment) {
        this.myRemoteDeployment = remoteDeployment;
        String presentableName = null;
        if (remoteDeployment != null) {
            DeploymentRuntime deploymentRuntime = remoteDeployment.getRuntime();
            DeploymentTask task = this.getDeploymentTask();
            if (deploymentRuntime != null) {
                presentableName = this.myServerInstance.getRuntimeDeploymentName(deploymentRuntime, task.getSource(), task.getConfiguration());
            }
        }
        this.setPresentableName(presentableName);
    }

    private boolean isLocalState() {
        return this.myRemoteDeployment == null || super.getStatus().isTransition();
    }

    @Override
    @NotNull
    public DeploymentStatus getStatus() {
        DeploymentStatus deploymentStatus = this.isLocalState() ? super.getStatus() : this.myRemoteDeployment.getStatus();
        if (deploymentStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl", "getStatus"));
        }
        return deploymentStatus;
    }

    @Override
    @NotNull
    public String getStatusText() {
        String string = this.isLocalState() ? super.getStatusText() : this.myRemoteDeployment.getStatusText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl", "getStatusText"));
        }
        return string;
    }

    @Override
    public boolean changeState(@NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
        if (oldStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStatus", "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl", "changeState"));
        }
        if (newStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatus", "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl", "changeState"));
        }
        boolean result2 = super.changeState(oldStatus, newStatus, statusText, runtime);
        if (result2 && this.myRemoteDeployment != null) {
            this.myRemoteDeployment.changeState(this.myRemoteDeployment.getStatus(), newStatus, statusText, this.myRemoteDeployment.getRuntime());
        }
        return result2;
    }
}

