/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ChangeTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    public ChangeTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getName() {
        String string = SpellCheckerBundle.message("change.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/ChangeTo", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpellCheckerBundle.message("change.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/ChangeTo", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor = Anchor.FIRST;
        if (anchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/ChangeTo", "getPopupActionAnchor"));
        }
        return anchor;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spellchecker/quickfixes/ChangeTo", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spellchecker/quickfixes/ChangeTo", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        Editor editor = PsiUtilBase.findEditor((PsiElement)element);
        if (editor == null) {
            return;
        }
        TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
        editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        String word = editor.getSelectionModel().getSelectedText();
        if (word == null || StringUtil.isEmpty((String)word)) {
            return;
        }
        ArrayList<LookupElementBuilder> lookupItems = new ArrayList<LookupElementBuilder>();
        for (String variant : this.getSuggestions(project)) {
            lookupItems.add(LookupElementBuilder.create((String)variant));
        }
        LookupElement[] items = new LookupElement[lookupItems.size()];
        items = lookupItems.toArray(items);
        LookupManager lookupManager = LookupManager.getInstance(project);
        lookupManager.showLookup(editor, items);
    }
}

