/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.util.IncorrectOperationException;

public class MatcherImplUtil {
    public static void transform(MatchOptions options) {
        if (options.hasVariableConstraints()) {
            return;
        }
        PatternCompiler.transformOldPattern(options);
    }

    public static PsiElement[] createTreeFromText(String text, PatternTreeContext context, FileType fileType, Project project) throws IncorrectOperationException {
        return MatcherImplUtil.createTreeFromText(text, context, fileType, null, null, project, false);
    }

    public static PsiElement[] createSourceTreeFromText(String text, PatternTreeContext context, FileType fileType, String extension, Project project, boolean physical) {
        Language language;
        StructuralSearchProfile profile;
        if (fileType instanceof LanguageFileType && (profile = StructuralSearchUtil.getProfileByLanguage(language = ((LanguageFileType)fileType).getLanguage())) != null) {
            return profile.createPatternTree(text, context, fileType, null, null, extension, project, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiElement[] createTreeFromText(String text, PatternTreeContext context, FileType fileType, Language language, String contextName, Project project, boolean physical) throws IncorrectOperationException {
        StructuralSearchProfile profile;
        if (language == null && fileType instanceof LanguageFileType) {
            language = ((LanguageFileType)fileType).getLanguage();
        }
        if (language != null && (profile = StructuralSearchUtil.getProfileByLanguage(language)) != null) {
            return profile.createPatternTree(text, context, fileType, language, contextName, null, project, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }
}

