/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MockFontLayoutService
extends FontLayoutService {
    private final int myCharWidth;
    private final int myLineHeight;
    private final int myDescent;

    public MockFontLayoutService(int charWidth, int lineHeight, int descent) {
        this.myCharWidth = charWidth;
        this.myLineHeight = lineHeight;
        this.myDescent = descent;
    }

    @Override
    @NotNull
    public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start, int end, boolean isRtl) {
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/testFramework/MockFontLayoutService", "layoutGlyphVector"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/testFramework/MockFontLayoutService", "layoutGlyphVector"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/testFramework/MockFontLayoutService", "layoutGlyphVector"));
        }
        MockGlyphVector mockGlyphVector = new MockGlyphVector(Arrays.copyOfRange(chars, start, end), isRtl);
        if (mockGlyphVector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/MockFontLayoutService", "layoutGlyphVector"));
        }
        return mockGlyphVector;
    }

    @Override
    public int charWidth(@NotNull FontMetrics fontMetrics, char c) {
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/testFramework/MockFontLayoutService", "charWidth"));
        }
        return this.myCharWidth;
    }

    @Override
    public int getHeight(@NotNull FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/testFramework/MockFontLayoutService", "getHeight"));
        }
        return this.myLineHeight;
    }

    @Override
    public int getDescent(@NotNull FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/testFramework/MockFontLayoutService", "getDescent"));
        }
        return this.myDescent;
    }

    private class MockGlyphVector
    extends GlyphVector {
        private final char[] myChars;
        private final boolean myIsRtl;

        private MockGlyphVector(char[] chars, boolean isRtl) {
            this.myChars = chars;
            this.myIsRtl = isRtl;
        }

        @Override
        public int getNumGlyphs() {
            return this.myChars.length;
        }

        @Override
        public int getGlyphCharIndex(int glyphIndex) {
            return this.myIsRtl ? this.myChars.length - 1 - glyphIndex : glyphIndex;
        }

        @Override
        public Point2D getGlyphPosition(int glyphIndex) {
            return new Point(glyphIndex * MockFontLayoutService.this.myCharWidth, 0);
        }

        @Override
        public Font getFont() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FontRenderContext getFontRenderContext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void performDefaultLayout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getGlyphCode(int glyphIndex) {
            return this.myChars[glyphIndex];
        }

        @Override
        public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Rectangle2D getLogicalBounds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Rectangle2D getVisualBounds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Shape getOutline() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Shape getOutline(float x, float y) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Shape getGlyphOutline(int glyphIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setGlyphPosition(int glyphIndex, Point2D newPos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AffineTransform getGlyphTransform(int glyphIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setGlyphTransform(int glyphIndex, AffineTransform newTX) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, float[] positionReturn) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Shape getGlyphLogicalBounds(int glyphIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Shape getGlyphVisualBounds(int glyphIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GlyphMetrics getGlyphMetrics(int glyphIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GlyphJustificationInfo getGlyphJustificationInfo(int glyphIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(GlyphVector set) {
            throw new UnsupportedOperationException();
        }
    }
}

