/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class ScanSourceCommentsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tools.ScanSourceCommentsAction");
    private final Map<String, CommentDescriptor> myComments = new HashMap<String, CommentDescriptor>();

    public void actionPerformed(AnActionEvent e) {
        final Project p = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        String file2 = Messages.showInputDialog((Project)p, (String)"Enter path to the file comments will be extracted to", (String)"Comments File Path", (Icon)Messages.getQuestionIcon());
        try {
            final PrintStream stream = new PrintStream(file2);
            stream.println("Comments in " + p.getName());
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    ProjectRootManager.getInstance((Project)p).getFileIndex().iterateContent(new ContentIterator(){

                        public boolean processFile(VirtualFile fileOrDir) {
                            if (fileOrDir.isDirectory()) {
                                indicator.setText("Extracting comments");
                                indicator.setText2(fileOrDir.getPresentableUrl());
                            }
                            ScanSourceCommentsAction.this.scanCommentsInFile(p, fileOrDir);
                            return true;
                        }
                    });
                    indicator.setText2("");
                    int count = 1;
                    for (CommentDescriptor descriptor : ScanSourceCommentsAction.this.myComments.values()) {
                        stream.println("#" + count + " ---------------------------------------------------------------");
                        descriptor.print(stream);
                        stream.println();
                        ++count;
                    }
                }
            }, "Generating Comments", true, p);
            stream.close();
        }
        catch (Throwable e1) {
            LOG.error(e1);
            Messages.showErrorDialog((Project)p, (String)("Error writing? " + e1.getMessage()), (String)"Problem writing");
        }
    }

    private void commentFound(VirtualFile file2, String text) {
        String reduced = text.replaceAll("\\s", "");
        CommentDescriptor descriptor = this.myComments.get(reduced);
        if (descriptor == null) {
            descriptor = new CommentDescriptor(text);
            this.myComments.put(reduced, descriptor);
        }
        descriptor.addFile(file2);
    }

    private void scanCommentsInFile(final Project project, final VirtualFile vFile) {
        if (!vFile.isDirectory() && vFile.getFileType() instanceof LanguageFileType) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                    if (psiFile == null) {
                        return;
                    }
                    for (PsiFile root : psiFile.getViewProvider().getAllFiles()) {
                        root.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                            public void visitComment(PsiComment comment) {
                                ScanSourceCommentsAction.this.commentFound(vFile, comment.getText());
                            }
                        });
                    }
                }
            });
        }
    }

    private class CommentDescriptor {
        private final String myText;
        private final Set<VirtualFile> myFiles = new LinkedHashSet<VirtualFile>();

        public CommentDescriptor(String text) {
            this.myText = text;
        }

        public void addFile(VirtualFile file2) {
            this.myFiles.add(file2);
        }

        public void print(PrintStream out) {
            out.println(this.myText);
            int count = this.myFiles.size();
            int i = 0;
            for (VirtualFile file2 : this.myFiles) {
                out.println(file2.getPresentableUrl());
                if (++i <= 5 || --count <= 2) continue;
                break;
            }
            if (count > 0) {
                out.println("And " + count + " more files");
            }
        }
    }
}

