/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.popup.WizardPopup;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MnemonicsSearch<T> {
    private final WizardPopup myPopup;
    private final Map<String, T> myChar2ValueMap = new HashMap<String, T>();

    public MnemonicsSearch(WizardPopup popup) {
        this.myPopup = popup;
        if (!this.myPopup.getStep().isMnemonicsNavigationEnabled()) {
            return;
        }
        MnemonicNavigationFilter filter = this.myPopup.getStep().getMnemonicNavigationFilter();
        List values = filter.getValues();
        for (Object each : values) {
            int pos = filter.getMnemonicPos(each);
            if (pos == -1) continue;
            String text = filter.getTextFor(each);
            String charText = text.substring(pos + 1, pos + 2);
            this.myChar2ValueMap.put(StringUtil.toUpperCase((String)charText), each);
            this.myChar2ValueMap.put(charText.toLowerCase(), each);
        }
    }

    public void process(KeyEvent e) {
        String s;
        T toSelect;
        if (e.isConsumed() || !StringUtil.isEmptyOrSpaces((String)this.myPopup.getSpeedSearch().getFilter())) {
            return;
        }
        if (Character.isLetterOrDigit(e.getKeyChar()) && (toSelect = this.myChar2ValueMap.get(s = Character.toString(e.getKeyChar()))) != null) {
            this.select(toSelect);
            e.consume();
        }
    }

    protected abstract void select(T var1);
}

