/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public class MessageBusUtil {
    public static <T> void runOnSyncPublisher(Project project, Topic<T> topic, Consumer<T> listener) {
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = MessageBusUtil.createPublisherRunnable(project, topic, listener);
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.runReadAction(runnable2);
        }
    }

    private static <T> Runnable createPublisherRunnable(final Project project, final Topic<T> topic, final Consumer<T> listener) {
        return new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                listener.consume(project.getMessageBus().syncPublisher(topic));
            }
        };
    }

    public static <T> void invokeLaterIfNeededOnSyncPublisher(Project project, Topic<T> topic, Consumer<T> listener) {
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = MessageBusUtil.createPublisherRunnable(project, topic, listener);
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2);
        }
    }

    @NotNull
    public static Disposable newMessageBusDisposer(final @NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/util/MessageBusUtil", "newMessageBusDisposer"));
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                messageBus.dispose();
            }
        };
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/MessageBusUtil", "newMessageBusDisposer"));
        }
        return disposable;
    }
}

