/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileInfoSetImpl
implements ConfigFileInfoSet {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl");
    @NonNls
    private static final String ELEMENT_NAME = "deploymentDescriptor";
    @NonNls
    private static final String ID_ATTRIBUTE = "name";
    @NonNls
    private static final String URL_ATTRIBUTE = "url";
    private final MultiValuesMap<ConfigFileMetaData, ConfigFileInfo> myConfigFiles = new MultiValuesMap();
    @Nullable
    private ConfigFileContainerImpl myContainer;
    private final ConfigFileMetaDataProvider myMetaDataProvider;

    public ConfigFileInfoSetImpl(ConfigFileMetaDataProvider metaDataProvider) {
        this.myMetaDataProvider = metaDataProvider;
    }

    public void addConfigFile(ConfigFileInfo descriptor) {
        this.myConfigFiles.put((Object)descriptor.getMetaData(), (Object)descriptor);
        this.onChange();
    }

    public void addConfigFile(ConfigFileMetaData metaData, String url) {
        this.addConfigFile(new ConfigFileInfo(metaData, url));
    }

    public void removeConfigFile(ConfigFileInfo descriptor) {
        this.myConfigFiles.remove((Object)descriptor.getMetaData(), (Object)descriptor);
        this.onChange();
    }

    public void replaceConfigFile(ConfigFileMetaData metaData, String newUrl) {
        this.myConfigFiles.removeAll((Object)metaData);
        this.addConfigFile(new ConfigFileInfo(metaData, newUrl));
    }

    public ConfigFileInfo updateConfigFile(ConfigFile configFile) {
        this.myConfigFiles.remove((Object)configFile.getMetaData(), (Object)configFile.getInfo());
        ConfigFileInfo info = new ConfigFileInfo(configFile.getMetaData(), configFile.getUrl());
        this.myConfigFiles.put((Object)info.getMetaData(), (Object)info);
        ((ConfigFileImpl)configFile).setInfo(info);
        return info;
    }

    public void removeConfigFiles(ConfigFileMetaData ... metaData) {
        for (ConfigFileMetaData data : metaData) {
            this.myConfigFiles.removeAll((Object)data);
        }
        this.onChange();
    }

    @Nullable
    public ConfigFileInfo getConfigFileInfo(ConfigFileMetaData metaData) {
        Collection descriptors = this.myConfigFiles.get((Object)metaData);
        if (descriptors == null || descriptors.isEmpty()) {
            return null;
        }
        return (ConfigFileInfo)descriptors.iterator().next();
    }

    public ConfigFileInfo[] getConfigFileInfos() {
        Collection configurations = this.myConfigFiles.values();
        return configurations.toArray(new ConfigFileInfo[configurations.size()]);
    }

    public void setConfigFileInfos(Collection<ConfigFileInfo> descriptors) {
        this.myConfigFiles.clear();
        for (ConfigFileInfo descriptor : descriptors) {
            this.myConfigFiles.put((Object)descriptor.getMetaData(), (Object)descriptor);
        }
        this.onChange();
    }

    private void onChange() {
        if (this.myContainer != null) {
            this.myContainer.updateDescriptors(this.myConfigFiles);
        }
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.myMetaDataProvider;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myConfigFiles.clear();
        List children2 = element.getChildren(ELEMENT_NAME);
        for (Element child : children2) {
            ConfigFileMetaData metaData;
            String id = child.getAttributeValue(ID_ATTRIBUTE);
            if (id == null || (metaData = this.myMetaDataProvider.findMetaData(id)) == null) continue;
            String url = child.getAttributeValue(URL_ATTRIBUTE);
            this.myConfigFiles.put((Object)metaData, (Object)new ConfigFileInfo(metaData, url));
        }
        this.onChange();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeSet<ConfigFileInfo> sortedConfigFiles = new TreeSet<ConfigFileInfo>(new Comparator<ConfigFileInfo>(){

            @Override
            public int compare(ConfigFileInfo o1, ConfigFileInfo o2) {
                int id = Comparing.compare((Comparable)((Object)o1.getMetaData().getId()), (Comparable)((Object)o2.getMetaData().getId()));
                return id != 0 ? id : Comparing.compare((Comparable)((Object)o1.getUrl()), (Comparable)((Object)o2.getUrl()));
            }
        });
        sortedConfigFiles.addAll(this.myConfigFiles.collectValues());
        for (ConfigFileInfo configuration : sortedConfigFiles) {
            Element child = new Element(ELEMENT_NAME);
            ConfigFileMetaData metaData = configuration.getMetaData();
            child.setAttribute(ID_ATTRIBUTE, metaData.getId());
            child.setAttribute(URL_ATTRIBUTE, configuration.getUrl());
            element.addContent(child);
        }
    }

    public void setContainer(@NotNull ConfigFileContainerImpl container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/util/descriptors/impl/ConfigFileInfoSetImpl", "setContainer"));
        }
        LOG.assertTrue(this.myContainer == null);
        this.myContainer = container;
        this.myContainer.updateDescriptors(this.myConfigFiles);
    }
}

