/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileSetVersionsFetcherBase<FS extends DownloadableFileSetDescription, F extends DownloadableFileDescription>
implements DownloadableFileSetVersions<FS> {
    private static final Comparator<DownloadableFileSetDescription> VERSIONS_COMPARATOR = new Comparator<DownloadableFileSetDescription>(){

        @Override
        public int compare(DownloadableFileSetDescription o1, DownloadableFileSetDescription o2) {
            return -StringUtil.compareVersionNumbers((String)o1.getVersionString(), (String)o2.getVersionString());
        }
    };
    protected final String myGroupId;
    private final URL[] myLocalUrls;

    public FileSetVersionsFetcherBase(@Nullable String groupId, @NotNull URL[] localUrls) {
        if (localUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localUrls", "com/intellij/util/download/impl/FileSetVersionsFetcherBase", "<init>"));
        }
        this.myLocalUrls = localUrls;
        this.myGroupId = groupId;
    }

    public void fetchVersions(final @NotNull DownloadableFileSetVersions.FileSetVersionsCallback<FS> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/util/download/impl/FileSetVersionsFetcherBase", "fetchVersions"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess(FileSetVersionsFetcherBase.this.fetchVersions());
            }
        });
    }

    @NotNull
    public List<FS> fetchVersions() {
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        Artifact[] versions = this.myGroupId != null ? LibrariesDownloadAssistant.getVersions((String)this.myGroupId, (URL[])this.myLocalUrls) : LibrariesDownloadAssistant.getVersions((URL[])this.myLocalUrls);
        ArrayList<FS> result2 = new ArrayList<FS>();
        for (Artifact version : versions) {
            ArtifactItem[] items = version.getItems();
            ArrayList<F> files = new ArrayList<F>();
            for (ArtifactItem item : items) {
                String url = item.getUrl();
                String prefix = version.getUrlPrefix();
                if (url == null) {
                    if (prefix != null) {
                        url = prefix + item.getName();
                    }
                } else {
                    url = FileSetVersionsFetcherBase.prependPrefix(url, prefix);
                }
                assert (url != null);
                files.add(this.createFileDescription(item, url, prefix));
            }
            result2.add(this.createVersion(version, files));
        }
        Collections.sort(result2, VERSIONS_COMPARATOR);
        ArrayList<FS> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileSetVersionsFetcherBase", "fetchVersions"));
        }
        return arrayList;
    }

    @NotNull
    protected static String prependPrefix(@NotNull String url, @Nullable String prefix) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/download/impl/FileSetVersionsFetcherBase", "prependPrefix"));
        }
        if (!url.startsWith("http://") && prefix != null) {
            url = prefix + url;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileSetVersionsFetcherBase", "prependPrefix"));
        }
        return string;
    }

    protected abstract F createFileDescription(ArtifactItem var1, String var2, @Nullable String var3);

    protected abstract FS createVersion(Artifact var1, List<F> var2);
}

