/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdateData;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MapDiffUpdateData<Key, Value>
extends UpdateData<Key, Value> {
    public static boolean ourDiffUpdateEnabled = SystemProperties.getBooleanProperty((String)"idea.disable.diff.index.update", (boolean)true);
    private Map<Key, Value> removedOrChangedKeys;
    private Map<Key, Value> addedKeys;
    private static final boolean DO_INFO_DUMP = ApplicationManager.getApplication().isInternal();
    private static final AtomicInteger requests = new AtomicInteger();
    private static final AtomicInteger totalRemovals = new AtomicInteger();
    private static final AtomicInteger totalAdditions = new AtomicInteger();
    private static final AtomicInteger incrementalRemovals = new AtomicInteger();
    private static final AtomicInteger incrementalAdditions = new AtomicInteger();

    public MapDiffUpdateData(ID<Key, Value> indexId) {
        super(indexId);
    }

    public static <Key, Value> void iterateAddedKeyAndValues(final int inputId, final UpdateData.AddedKeyProcessor<Key, Value> consumer, Map<Key, Value> data) throws StorageException {
        if (data instanceof THashMap) {
            final Ref exceptionRef = new Ref();
            boolean b = ((THashMap)data).forEachEntry(new TObjectObjectProcedure<Key, Value>(){

                public boolean execute(Key key, Value value) {
                    try {
                        consumer.process(key, value, inputId);
                    }
                    catch (StorageException ex) {
                        exceptionRef.set((Object)ex);
                        return false;
                    }
                    return true;
                }
            });
            if (!b) {
                throw (StorageException)exceptionRef.get();
            }
        } else {
            for (Map.Entry<Key, Value> entry : data.entrySet()) {
                consumer.process(entry.getKey(), entry.getValue(), inputId);
            }
        }
    }

    public static <Key> void iterateRemovedKeys(Collection<Key> keyCollection, int inputId, UpdateData.RemovedOrUpdatedKeyProcessor<Key> consumer) throws StorageException {
        for (Key key : keyCollection) {
            consumer.process(key, inputId);
        }
    }

    @Override
    public void iterateRemovedOrUpdatedKeys(int inputId, UpdateData.RemovedOrUpdatedKeyProcessor<Key> consumer) throws StorageException {
        this.calcDiff();
        MapDiffUpdateData.iterateRemovedKeys(this.removedOrChangedKeys.keySet(), inputId, consumer);
    }

    private void calcDiff() throws StorageException {
        if (this.removedOrChangedKeys != null) {
            return;
        }
        try {
            Map<Key, Value> currentValue = this.getCurrentValue();
            Map<Key, Value> newValue = this.getNewValue();
            if (!currentValue.isEmpty()) {
                if (newValue.isEmpty()) {
                    this.addedKeys = newValue;
                    this.removedOrChangedKeys = currentValue;
                    return;
                }
                for (Map.Entry<Key, Value> e : currentValue.entrySet()) {
                    Value newValueForKey = newValue.get(e.getKey());
                    if (Comparing.equal(newValueForKey, e.getValue()) && (newValueForKey != null || newValue.containsKey(e.getKey()))) continue;
                    if (this.removedOrChangedKeys == null) {
                        this.removedOrChangedKeys = new THashMap();
                    }
                    this.removedOrChangedKeys.put(e.getKey(), e.getValue());
                    if (!newValue.containsKey(e.getKey())) continue;
                    if (this.addedKeys == null) {
                        this.addedKeys = new THashMap();
                    }
                    this.addedKeys.put(e.getKey(), newValueForKey);
                }
            } else if (newValue.isEmpty()) {
                this.addedKeys = newValue;
                this.removedOrChangedKeys = currentValue;
                return;
            }
            if (!newValue.isEmpty()) {
                if (currentValue.isEmpty()) {
                    this.addedKeys = newValue;
                    this.removedOrChangedKeys = currentValue;
                    return;
                }
                for (Map.Entry<Key, Value> e : newValue.entrySet()) {
                    if (currentValue.containsKey(e.getKey())) continue;
                    if (this.addedKeys == null) {
                        this.addedKeys = new THashMap();
                    }
                    this.addedKeys.put(e.getKey(), e.getValue());
                }
            }
            if (this.removedOrChangedKeys == null) {
                this.removedOrChangedKeys = Collections.emptyMap();
            }
            if (this.addedKeys == null) {
                this.addedKeys = Collections.emptyMap();
            }
            int totalRequests = requests.incrementAndGet();
            totalRemovals.addAndGet(currentValue.size());
            totalAdditions.addAndGet(newValue.size());
            incrementalAdditions.addAndGet(this.addedKeys.size());
            incrementalRemovals.addAndGet(this.removedOrChangedKeys.size());
            if ((totalRequests & 0xFFF) == 0 && DO_INFO_DUMP) {
                Logger.getInstance(this.getClass()).info("Incremental index diff update:" + requests + ", removals:" + totalRemovals + "->" + incrementalRemovals + ", additions:" + totalAdditions + "->" + incrementalAdditions);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    protected abstract Map<Key, Value> getNewValue();

    protected abstract Map<Key, Value> getCurrentValue() throws IOException;

    @Override
    public void iterateAddedKeys(int inputId, UpdateData.AddedKeyProcessor<Key, Value> consumer) throws StorageException {
        this.calcDiff();
        MapDiffUpdateData.iterateAddedKeyAndValues(inputId, consumer, this.addedKeys);
    }
}

