/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.annotations.NotNull;

public class ProjectContentFileFilter
implements VirtualFileFilter {
    private final Project project;
    private final VirtualFileFilter filter;
    private ProjectFileIndex fileIndex;

    public ProjectContentFileFilter(@NotNull Project project, @NotNull VirtualFileFilter filter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/ProjectContentFileFilter", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/tree/ProjectContentFileFilter", "<init>"));
        }
        this.project = project;
        this.filter = filter;
    }

    public boolean accept(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ui/tree/ProjectContentFileFilter", "accept"));
        }
        if (!this.filter.accept(file2)) {
            return false;
        }
        if (this.fileIndex == null) {
            this.fileIndex = ProjectRootManager.getInstance((Project)this.project).getFileIndex();
        }
        return this.fileIndex.isInContent(file2);
    }
}

