/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.structure;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.structure.DomStructureViewTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final Function<DomElement, DomService.StructureViewMode> myDescriptor;
    private final XmlFile myFile;

    public DomStructureViewBuilder(XmlFile file2, Function<DomElement, DomService.StructureViewMode> descriptor) {
        this.myFile = file2;
        this.myDescriptor = descriptor;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
        DomStructureViewTreeModel domStructureViewTreeModel = new DomStructureViewTreeModel(this.myFile, this.myDescriptor, editor);
        if (domStructureViewTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/structure/DomStructureViewBuilder", "createStructureViewModel"));
        }
        return domStructureViewTreeModel;
    }

    public boolean isRootNodeShown() {
        return true;
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/xml/structure/DomStructureViewBuilder", "createStructureView"));
        }
        StructureViewComponent structureViewComponent = new StructureViewComponent(fileEditor, this.createStructureViewModel(fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null), project, true){

            @Override
            public AsyncResult<AbstractTreeNode> expandPathToElement(Object element) {
                if (element instanceof XmlElement && ((XmlElement)element).isValid()) {
                    XmlElement xmlElement = (XmlElement)element;
                    XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlElement, XmlTag.class, (boolean)false);
                    while (tag != null) {
                        DomElement domElement = DomManager.getDomManager((Project)xmlElement.getProject()).getDomElement(tag);
                        if (domElement != null) {
                            for (DomElement curElement = domElement; curElement != null; curElement = curElement.getParent()) {
                                if (DomStructureViewBuilder.this.myDescriptor.fun((Object)curElement) != DomService.StructureViewMode.SHOW) continue;
                                return super.expandPathToElement(curElement.getXmlElement());
                            }
                        }
                        tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class, (boolean)true);
                    }
                }
                return super.expandPathToElement(element);
            }
        };
        if (structureViewComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/structure/DomStructureViewBuilder", "createStructureView"));
        }
        return structureViewComponent;
    }
}

