/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.openapi.util.Pair;
import com.intellij.util.NotNullFunction;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class GraphElementComparatorByLayoutIndex
implements Comparator<GraphElement> {
    @NotNull
    private final NotNullFunction<Integer, Integer> myLayoutIndexGetter;

    public GraphElementComparatorByLayoutIndex(@NotNull NotNullFunction<Integer, Integer> layoutIndexGetter) {
        if (layoutIndexGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutIndexGetter", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "<init>"));
        }
        this.myLayoutIndexGetter = layoutIndexGetter;
    }

    @Override
    public int compare(@NotNull GraphElement o1, @NotNull GraphElement o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "compare"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "compare"));
        }
        if (o1 instanceof GraphEdge && o2 instanceof GraphEdge) {
            GraphEdge edge1 = (GraphEdge)o1;
            GraphEdge edge2 = (GraphEdge)o2;
            Pair<Integer, Integer> normalEdge1 = LinearGraphUtils.asNormalEdge(edge1);
            Pair<Integer, Integer> normalEdge2 = LinearGraphUtils.asNormalEdge(edge2);
            if (normalEdge1 == null) {
                return -this.compare2(edge2, new GraphNode(LinearGraphUtils.getNotNullNodeIndex(edge1)));
            }
            if (normalEdge2 == null) {
                return this.compare2(edge1, new GraphNode(LinearGraphUtils.getNotNullNodeIndex(edge2)));
            }
            if (((Integer)normalEdge1.first).equals(normalEdge2.first)) {
                if (this.getLayoutIndex((Integer)normalEdge1.second) != this.getLayoutIndex((Integer)normalEdge2.second)) {
                    return this.getLayoutIndex((Integer)normalEdge1.second) - this.getLayoutIndex((Integer)normalEdge2.second);
                }
                return (Integer)normalEdge1.second - (Integer)normalEdge2.second;
            }
            if ((Integer)normalEdge1.first < (Integer)normalEdge2.first) {
                return this.compare2(edge1, new GraphNode((Integer)normalEdge2.first));
            }
            return -this.compare2(edge2, new GraphNode((Integer)normalEdge1.first));
        }
        if (o1 instanceof GraphEdge && o2 instanceof GraphNode) {
            return this.compare2((GraphEdge)o1, (GraphNode)o2);
        }
        if (o1 instanceof GraphNode && o2 instanceof GraphEdge) {
            return -this.compare2((GraphEdge)o2, (GraphNode)o1);
        }
        assert (false);
        return 0;
    }

    private int compare2(@NotNull GraphEdge edge, @NotNull GraphNode node) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "compare2"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "compare2"));
        }
        Pair<Integer, Integer> normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            return this.getLayoutIndex(LinearGraphUtils.getNotNullNodeIndex(edge)) - this.getLayoutIndex(node.getNodeIndex());
        }
        int upEdgeLI = this.getLayoutIndex((Integer)normalEdge.first);
        int downEdgeLI = this.getLayoutIndex((Integer)normalEdge.second);
        int nodeLI = this.getLayoutIndex(node.getNodeIndex());
        if (Math.max(upEdgeLI, downEdgeLI) != nodeLI) {
            return Math.max(upEdgeLI, downEdgeLI) - nodeLI;
        }
        return (Integer)normalEdge.first - node.getNodeIndex();
    }

    private int getLayoutIndex(int nodeIndex) {
        return (Integer)this.myLayoutIndexGetter.fun((Object)nodeIndex);
    }
}

