/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print.elements;

import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import org.jetbrains.annotations.NotNull;

public abstract class PrintElementWithGraphElement
implements PrintElement {
    protected final int myRowIndex;
    protected final int myPositionInCurrentRow;
    @NotNull
    protected final GraphElement myGraphElement;
    @NotNull
    protected final PrintElementManager myPrintElementManager;

    protected PrintElementWithGraphElement(int rowIndex, int positionInCurrentRow, @NotNull GraphElement graphElement, @NotNull PrintElementManager printElementManager) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement", "<init>"));
        }
        if (printElementManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementManager", "com/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement", "<init>"));
        }
        this.myRowIndex = rowIndex;
        this.myPositionInCurrentRow = positionInCurrentRow;
        this.myGraphElement = graphElement;
        this.myPrintElementManager = printElementManager;
    }

    @NotNull
    public GraphElement getGraphElement() {
        GraphElement graphElement = this.myGraphElement;
        if (graphElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement", "getGraphElement"));
        }
        return graphElement;
    }

    public int getRowIndex() {
        return this.myRowIndex;
    }

    public int getPositionInCurrentRow() {
        return this.myPositionInCurrentRow;
    }

    public int getColorId() {
        return this.myPrintElementManager.getColorId(this.myGraphElement);
    }

    public boolean isSelected() {
        return this.myPrintElementManager.isSelected(this);
    }

    public static PrintElementWithGraphElement converted(@NotNull PrintElementWithGraphElement element, @NotNull GraphElement convertedGraphElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement", "converted"));
        }
        if (convertedGraphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertedGraphElement", "com/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement", "converted"));
        }
        return new PrintElementWithGraphElement(element.getRowIndex(), element.getPositionInCurrentRow(), convertedGraphElement, element.myPrintElementManager){};
    }
}

