/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsFileUtil {
    public static final int FILE_PATH_LIMIT = 7600;

    public static List<List<String>> chunkRelativePaths(List<String> files) {
        int i;
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start = 0;
        int size = 0;
        for (i = 0; i < files.size(); ++i) {
            String p = files.get(i);
            if (size + p.length() > 7600) {
                if (start == i) {
                    rc.add(files.subList(i, i + 1));
                    start = i + 1;
                } else {
                    rc.add(files.subList(start, i));
                    start = i;
                }
                size = 0;
                continue;
            }
            size += p.length();
        }
        if (start != files.size()) {
            rc.add(files.subList(start, i));
        }
        return rc;
    }

    public static List<List<String>> chunkPaths(VirtualFile root, Collection<FilePath> files) {
        return VcsFileUtil.chunkRelativePaths(VcsFileUtil.toRelativePaths(root, files));
    }

    public static List<List<String>> chunkFiles(@NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcsUtil/VcsFileUtil", "chunkFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcsUtil/VcsFileUtil", "chunkFiles"));
        }
        return VcsFileUtil.chunkRelativePaths(VcsFileUtil.toRelativeFiles(root, files));
    }

    public static String getRelativeFilePath(VirtualFile file2, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/vcsUtil/VcsFileUtil", "getRelativeFilePath"));
        }
        return VcsFileUtil.getRelativeFilePath(file2.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file2, @NotNull VirtualFile baseDir) {
        String basePath;
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/vcsUtil/VcsFileUtil", "getRelativeFilePath"));
        }
        if (SystemInfo.isWindows) {
            file2 = file2.replace('\\', '/');
        }
        if (!file2.startsWith(basePath = baseDir.getPath())) {
            return file2;
        }
        if (file2.equals(basePath)) {
            return ".";
        }
        return file2.substring(baseDir.getPath().length() + 1);
    }

    public static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static String relativePath(VirtualFile root, FilePath path) {
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), path.getIOFile());
    }

    public static String relativePath(File root, FilePath path) {
        return VcsFileUtil.relativePath(root, path.getIOFile());
    }

    public static String relativePath(File root, VirtualFile file2) {
        return VcsFileUtil.relativePath(root, VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(VirtualFile root, VirtualFile file2) {
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativeOrFullPath(VirtualFile root, VirtualFile file2) {
        if (root == null) {
            file2.getPath();
        }
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(File root, File path) {
        String rc = FileUtil.getRelativePath((File)root, (File)path);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + path + " cannot be made relative to " + root);
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root, @NotNull Collection<FilePath> filePaths) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcsUtil/VcsFileUtil", "toRelativePaths"));
        }
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/vcsUtil/VcsFileUtil", "toRelativePaths"));
        }
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath path : filePaths) {
            rc.add(VcsFileUtil.relativePath(root, path));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcsUtil/VcsFileUtil", "toRelativeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcsUtil/VcsFileUtil", "toRelativeFiles"));
        }
        ArrayList<String> rc = new ArrayList<String>(files.size());
        for (VirtualFile file2 : files) {
            rc.add(VcsFileUtil.relativePath(root, file2));
        }
        return rc;
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull Collection<VirtualFile> affectedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcsUtil/VcsFileUtil", "markFilesDirty"));
        }
        if (affectedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFiles", "com/intellij/vcsUtil/VcsFileUtil", "markFilesDirty"));
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile file2 : affectedFiles) {
            if (file2.isDirectory()) {
                dirty.dirDirtyRecursively(file2);
                continue;
            }
            dirty.fileDirty(file2);
        }
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull List<FilePath> affectedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcsUtil/VcsFileUtil", "markFilesDirty"));
        }
        if (affectedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFiles", "com/intellij/vcsUtil/VcsFileUtil", "markFilesDirty"));
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath file2 : affectedFiles) {
            if (file2.isDirectory()) {
                dirty.dirDirtyRecursively(file2);
                continue;
            }
            dirty.fileDirty(file2);
        }
    }

    @Nullable
    public static VirtualFile getPossibleBase(VirtualFile file2, String ... path) {
        if (file2 == null || path.length == 0) {
            return null;
        }
        VirtualFile current = file2;
        ArrayList<VirtualFile> backTrace = new ArrayList<VirtualFile>();
        int idx = path.length - 1;
        while (current != null) {
            if (SystemInfo.isFileSystemCaseSensitive ? current.getName().equals(path[idx]) : current.getName().equalsIgnoreCase(path[idx])) {
                if (idx == 0) {
                    return current;
                }
                --idx;
            } else if (idx != path.length - 1) {
                int diff = path.length - 1 - idx - 1;
                for (int i = 0; i < diff; ++i) {
                    current = (VirtualFile)backTrace.remove(backTrace.size() - 1);
                }
                idx = path.length - 1;
                continue;
            }
            backTrace.add(current);
            current = current.getParent();
        }
        return null;
    }
}

