/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XSourcePositionImpl
implements XSourcePosition {
    private final VirtualFile myFile;
    private final int myLine;
    private final int myOffset;

    private XSourcePositionImpl(@NotNull VirtualFile file2, int line, int offset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XSourcePositionImpl", "<init>"));
        }
        this.myFile = file2;
        this.myLine = line;
        this.myOffset = offset;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl", "getFile"));
        }
        return virtualFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static XSourcePositionImpl createByOffset(@Nullable VirtualFile file2, int offset) {
        if (file2 == null) {
            return null;
        }
        AccessToken lock = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document == null) {
                XSourcePositionImpl xSourcePositionImpl = null;
                return xSourcePositionImpl;
            }
            int line = offset <= document.getTextLength() ? document.getLineNumber(offset) : -1;
            XSourcePositionImpl xSourcePositionImpl = new XSourcePositionImpl(file2, line, offset);
            return xSourcePositionImpl;
        }
        finally {
            lock.finish();
        }
    }

    @Nullable
    public static XSourcePositionImpl createByElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile file2 = element.getContainingFile().getVirtualFile();
        if (file2 == null) {
            return null;
        }
        return XSourcePositionImpl.createByOffset(file2, element.getTextOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static XSourcePositionImpl create(@Nullable VirtualFile file2, int line) {
        if (file2 == null) {
            return null;
        }
        AccessToken lock = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            int offset;
            if (file2 instanceof LightVirtualFile || file2 instanceof HttpVirtualFile) {
                offset = -1;
            } else {
                Document document;
                Document document2 = document = file2.isValid() ? FileDocumentManager.getInstance().getDocument(file2) : null;
                if (document == null) {
                    XSourcePositionImpl xSourcePositionImpl = null;
                    return xSourcePositionImpl;
                }
                if (line < 0) {
                    line = 0;
                }
                offset = line < document.getLineCount() ? document.getLineStartOffset(line) : -1;
            }
            XSourcePositionImpl xSourcePositionImpl = new XSourcePositionImpl(file2, line, offset);
            return xSourcePositionImpl;
        }
        finally {
            lock.finish();
        }
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createNavigatable"));
        }
        OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor(project, this);
        if (openFileDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createNavigatable"));
        }
        return openFileDescriptor;
    }

    @NotNull
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createOpenFileDescriptor"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createOpenFileDescriptor"));
        }
        Navigatable navigatable = position.createNavigatable(project);
        if (navigatable instanceof OpenFileDescriptor) {
            OpenFileDescriptor openFileDescriptor = (OpenFileDescriptor)navigatable;
            if (openFileDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createOpenFileDescriptor"));
            }
            return openFileDescriptor;
        }
        OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor(project, position);
        if (openFileDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createOpenFileDescriptor"));
        }
        return openFileDescriptor;
    }

    @NotNull
    public static OpenFileDescriptor doCreateOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XSourcePositionImpl", "doCreateOpenFileDescriptor"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/XSourcePositionImpl", "doCreateOpenFileDescriptor"));
        }
        OpenFileDescriptor openFileDescriptor = position.getOffset() != -1 ? new OpenFileDescriptor(project, position.getFile(), position.getOffset()) : new OpenFileDescriptor(project, position.getFile(), position.getLine(), 0);
        if (openFileDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl", "doCreateOpenFileDescriptor"));
        }
        return openFileDescriptor;
    }

    public String toString() {
        return "XSourcePositionImpl[" + this.myFile + ":" + this.myLine + "(" + this.myOffset + ")]";
    }
}

