/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BreadcrumbsLoaderComponent
extends AbstractProjectComponent {
    public BreadcrumbsLoaderComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "<init>"));
        }
        super(project);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("HtmlBreadcrumbsComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "getComponentName"));
        }
        return "HtmlBreadcrumbsComponent";
    }

    public void initComponent() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        MyVirtualFileListener listener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)listener, (Disposable)this.myProject);
        UISettings.getInstance().addUISettingsListener((UISettingsListener)new MyUISettingsListener(), (Disposable)this.myProject);
    }

    private void reinitBreadcrumbsInAllEditors() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            BreadcrumbsLoaderComponent.reinitBreadcrumbsComponent(fileEditorManager, virtualFile);
        }
    }

    private static void reinitBreadcrumbsComponent(final @NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "reinitBreadcrumbsComponent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "reinitBreadcrumbsComponent"));
        }
        if (BreadcrumbsLoaderComponent.isSuitable(fileEditorManager.getProject(), file2)) {
            FileEditor[] fileEditors;
            for (final FileEditor fileEditor : fileEditors = fileEditorManager.getAllEditors(file2)) {
                Editor editor;
                if (!(fileEditor instanceof TextEditor) || BreadcrumbsXmlWrapper.getBreadcrumbsComponent(editor = ((TextEditor)fileEditor).getEditor()) != null) continue;
                final BreadcrumbsXmlWrapper wrapper = new BreadcrumbsXmlWrapper(editor);
                JComponent c = wrapper.getComponent();
                fileEditorManager.addTopComponent(fileEditor, c);
                Disposer.register((Disposable)fileEditor, (Disposable)new Disposable(){

                    public void dispose() {
                        BreadcrumbsLoaderComponent.disposeWrapper(fileEditorManager, fileEditor, wrapper);
                    }
                });
            }
        } else {
            BreadcrumbsLoaderComponent.removeBreadcrumbs(fileEditorManager, file2);
        }
    }

    private static void removeBreadcrumbs(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        FileEditor[] fileEditors;
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "removeBreadcrumbs"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "removeBreadcrumbs"));
        }
        for (FileEditor fileEditor : fileEditors = fileEditorManager.getAllEditors(file2)) {
            Editor editor;
            BreadcrumbsXmlWrapper wrapper;
            if (!(fileEditor instanceof TextEditor) || (wrapper = BreadcrumbsXmlWrapper.getBreadcrumbsComponent(editor = ((TextEditor)fileEditor).getEditor())) == null) continue;
            BreadcrumbsLoaderComponent.disposeWrapper(fileEditorManager, fileEditor, wrapper);
        }
    }

    private static boolean isSuitable(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "isSuitable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "isSuitable"));
        }
        if (file2 instanceof HttpVirtualFile) {
            return false;
        }
        FileViewProvider provider = PsiManager.getInstance((Project)project).findViewProvider(file2);
        return provider != null && BreadcrumbsXmlWrapper.findInfoProvider(provider) != null;
    }

    private static void disposeWrapper(@NotNull FileEditorManager fileEditorManager, @NotNull FileEditor fileEditor, @NotNull BreadcrumbsXmlWrapper wrapper) {
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "disposeWrapper"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "disposeWrapper"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "disposeWrapper"));
        }
        fileEditorManager.removeTopComponent(fileEditor, wrapper.getComponent());
        Disposer.dispose((Disposable)wrapper);
    }

    private class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings source) {
            BreadcrumbsLoaderComponent.this.reinitBreadcrumbsInAllEditors();
        }
    }

    private class MyFileTypeListener
    extends FileTypeListener.Adapter {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent$MyFileTypeListener", "fileTypesChanged"));
            }
            BreadcrumbsLoaderComponent.this.reinitBreadcrumbsInAllEditors();
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file2;
            FileEditorManager fileEditorManager;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent$MyVirtualFileListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName()) && (fileEditorManager = FileEditorManager.getInstance((Project)BreadcrumbsLoaderComponent.this.myProject)).isFileOpen(file2 = event.getFile())) {
                BreadcrumbsLoaderComponent.reinitBreadcrumbsComponent(fileEditorManager, file2);
            }
        }
    }

    private static class MyFileEditorManagerListener
    extends FileEditorManagerAdapter {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent$MyFileEditorManagerListener", "fileOpened"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent$MyFileEditorManagerListener", "fileOpened"));
            }
            BreadcrumbsLoaderComponent.reinitBreadcrumbsComponent(source, file2);
        }
    }
}

