/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlTagInplaceRenamer {
    @NonNls
    private static final String PRIMARY_VARIABLE_NAME = "PrimaryVariable";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OtherVariable";
    private final Editor myEditor;
    private static final Stack<XmlTagInplaceRenamer> ourRenamersStack = new Stack();
    private ArrayList<RangeHighlighter> myHighlighters;

    private XmlTagInplaceRenamer(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/refactoring/XmlTagInplaceRenamer", "<init>"));
        }
        this.myEditor = editor;
    }

    public static void rename(Editor editor, @NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/refactoring/XmlTagInplaceRenamer", "rename"));
        }
        if (!ourRenamersStack.isEmpty()) {
            ((XmlTagInplaceRenamer)ourRenamersStack.peek()).finish();
        }
        XmlTagInplaceRenamer renamer = new XmlTagInplaceRenamer(editor);
        ourRenamersStack.push((Object)renamer);
        renamer.rename(tag);
    }

    private void rename(final @NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/refactoring/XmlTagInplaceRenamer", "rename"));
        }
        final Pair<ASTNode, ASTNode> pair = this.getNamePair(tag);
        if (pair == null) {
            return;
        }
        final Project project = this.myEditor.getProject();
        if (project != null) {
            final ArrayList<TextRange> highlightRanges = new ArrayList<TextRange>();
            highlightRanges.add(((ASTNode)pair.first).getTextRange());
            if (pair.second != null) {
                highlightRanges.add(((ASTNode)pair.second).getTextRange());
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)tag)) {
                return;
            }
            this.myHighlighters = new ArrayList();
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            int offset = XmlTagInplaceRenamer.this.myEditor.getCaretModel().getOffset();
                            XmlTagInplaceRenamer.this.myEditor.getCaretModel().moveToOffset(tag.getTextOffset());
                            Template t = XmlTagInplaceRenamer.buildTemplate(tag, (Pair<ASTNode, ASTNode>)pair);
                            TemplateManager.getInstance(project).startTemplate(XmlTagInplaceRenamer.this.myEditor, t, new TemplateEditingAdapter(){

                                @Override
                                public void templateFinished(Template template, boolean brokenOff) {
                                    XmlTagInplaceRenamer.this.finish();
                                }

                                @Override
                                public void templateCancelled(Template template) {
                                    XmlTagInplaceRenamer.this.finish();
                                }
                            }, new PairProcessor<String, String>(){

                                public boolean process(String variableName, String value) {
                                    return value.length() == 0 || value.charAt(value.length() - 1) != ' ';
                                }
                            });
                            XmlTagInplaceRenamer.this.myEditor.getCaretModel().moveToOffset(offset);
                            XmlTagInplaceRenamer.addHighlights(highlightRanges, XmlTagInplaceRenamer.this.myEditor, XmlTagInplaceRenamer.this.myHighlighters);
                        }
                    });
                }
            }, RefactoringBundle.message((String)"rename.title"), null);
        }
    }

    private void finish() {
        ourRenamersStack.pop();
        if (this.myHighlighters != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myEditor.getProject());
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
            }
        }
    }

    private Pair<ASTNode, ASTNode> getNamePair(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/refactoring/XmlTagInplaceRenamer", "getNamePair"));
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        ASTNode node = tag.getNode();
        assert (node != null);
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
        if (startTagName == null) {
            return null;
        }
        ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(node);
        ASTNode selected = endTagName == null || startTagName.getTextRange().contains(offset) || startTagName.getTextRange().contains(offset - 1) ? startTagName : endTagName;
        ASTNode other = selected == startTagName ? endTagName : startTagName;
        return Pair.create((Object)selected, (Object)other);
    }

    private static Template buildTemplate(@NotNull XmlTag tag, @NotNull Pair<ASTNode, ASTNode> pair) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/refactoring/XmlTagInplaceRenamer", "buildTemplate"));
        }
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/xml/refactoring/XmlTagInplaceRenamer", "buildTemplate"));
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)tag);
        final ASTNode selected = (ASTNode)pair.first;
        ASTNode other = (ASTNode)pair.second;
        builder.replaceElement(selected.getPsi(), PRIMARY_VARIABLE_NAME, (Expression)new EmptyExpression(){

            @Override
            public Result calculateQuickResult(ExpressionContext context) {
                return new TextResult(selected.getText());
            }

            @Override
            public Result calculateResult(ExpressionContext context) {
                return new TextResult(selected.getText());
            }
        }, true);
        if (other != null) {
            builder.replaceElement(other.getPsi(), OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
        return builder.buildInlineTemplate();
    }

    private static void addHighlights(List<TextRange> ranges, Editor editor, ArrayList<RangeHighlighter> highlighters) {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
        for (TextRange range : ranges) {
            highlightManager.addOccurrenceHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, 0, highlighters, null);
        }
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
    }
}

