/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDeclareIdInCommentAction
implements LocalQuickFix {
    private final String myId;

    public XmlDeclareIdInCommentAction(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xml/util/XmlDeclareIdInCommentAction", "<init>"));
        }
        this.myId = id;
    }

    @NotNull
    public String getName() {
        String string = XmlErrorMessages.message("declare.id.in.comment.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlDeclareIdInCommentAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlDeclareIdInCommentAction", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    public static String getImplicitlyDeclaredId(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/xml/util/XmlDeclareIdInCommentAction", "getImplicitlyDeclaredId"));
        }
        String text = XmlDeclareIdInCommentAction.getUncommentedText(comment);
        if (text == null) {
            return null;
        }
        if (text.startsWith("@declare id=\"")) {
            String result2 = text.substring("@declare id=\"".length() - 1);
            return StringUtil.unquoteString((String)result2);
        }
        return null;
    }

    @Nullable
    private static String getUncommentedText(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/xml/util/XmlDeclareIdInCommentAction", "getUncommentedText"));
        }
        PsiFile psiFile = comment.getContainingFile();
        Language language = psiFile.getViewProvider().getBaseLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter != null) {
            String text = comment.getText();
            String prefix = commenter.getBlockCommentPrefix();
            if (prefix != null && text.startsWith(prefix)) {
                text = text.substring(prefix.length());
                String suffix = commenter.getBlockCommentSuffix();
                if (suffix != null && text.length() > suffix.length()) {
                    return text.substring(0, text.length() - suffix.length()).trim();
                }
            }
        }
        return null;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/XmlDeclareIdInCommentAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/util/XmlDeclareIdInCommentAction", "applyFix"));
        }
        final PsiElement psiElement = descriptor.getPsiElement();
        final PsiFile psiFile = psiElement.getContainingFile();
        new WriteCommandAction(project, new PsiFile[]{psiFile}){

            protected void run(@NotNull Result result2) throws Throwable {
                PsiElement element;
                PsiFile psi;
                XmlTag[] tags;
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xml/util/XmlDeclareIdInCommentAction$1", "run"));
                }
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
                if (tag == null) {
                    return;
                }
                Language language = psiFile.getViewProvider().getBaseLanguage();
                Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
                if (commenter == null) {
                    return;
                }
                PsiFile tempFile2 = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (FileType)language.getAssociatedFileType(), (CharSequence)(commenter.getBlockCommentPrefix() + "@declare id=\"" + XmlDeclareIdInCommentAction.this.myId + "\"" + commenter.getBlockCommentSuffix() + "\n"));
                XmlTag parent = tag.getParentTag();
                if (parent != null && parent.isValid() && (tags = parent.getSubTags()).length > 0 && (psi = tempFile2.getViewProvider().getPsi(language)) != null && (element = psi.findElementAt(1)) instanceof PsiComment) {
                    parent.getNode().addChild(element.getNode(), tags[0].getNode());
                }
            }
        }.execute();
    }
}

