/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InstanceofInterfacesInspection
extends BaseInspection {
    public boolean ignoreAbstractClasses = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instanceof.concrete.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofInterfacesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instanceof.concrete.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofInterfacesInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("instanceof.interfaces.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAbstractClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofInterfacesVisitor();
    }

    private class InstanceofInterfacesVisitor
    extends BaseInspectionVisitor {
        private InstanceofInterfacesVisitor() {
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/InstanceofInterfacesInspection$InstanceofInterfacesVisitor", "visitInstanceOfExpression"));
            }
            super.visitInstanceOfExpression(expression);
            PsiTypeElement typeElement = expression.getCheckType();
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement, InstanceofInterfacesInspection.this.ignoreAbstractClasses)) {
                return;
            }
            if (typeElement == null) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }
    }
}

