/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInitializerInspection
extends BaseInspection {
    public boolean onlyWarnWhenConstructor = false;

    @NotNull
    public String getID() {
        if ("NonStaticInitializer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection", "getID"));
        }
        return "NonStaticInitializer";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.initializer.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.initializer.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.initializer.option", new Object[0]), (InspectionProfileEntry)this, "onlyWarnWhenConstructor");
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (PsiUtil.isInnerClass((PsiClass)aClass)) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new MoveToConstructorFix()};
            if (inspectionGadgetsFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection", "buildFixes"));
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ChangeModifierFix("static"), new MoveToConstructorFix()};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassInitializerVisitor();
    }

    private class ClassInitializerVisitor
    extends BaseInspectionVisitor {
        private ClassInitializerVisitor() {
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            super.visitClassInitializer(initializer);
            if (initializer.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = initializer.getContainingClass();
            if (aClass == null || aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (ClassInitializerInspection.this.onlyWarnWhenConstructor && aClass.getConstructors().length == 0) {
                return;
            }
            this.registerClassInitializerError(initializer, aClass);
        }
    }

    private static class MoveToConstructorFix
    extends InspectionGadgetsFix {
        private MoveToConstructorFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("class.initializer.move.code.to.constructor.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection$MoveToConstructorFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection$MoveToConstructorFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement brace = descriptor.getPsiElement();
            PsiElement parent = brace.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiClassInitializer)) {
                return;
            }
            PsiClassInitializer initializer = (PsiClassInitializer)grandParent;
            PsiClass aClass = initializer.getContainingClass();
            if (aClass == null) {
                return;
            }
            Collection<PsiMethod> constructors = MoveToConstructorFix.getOrCreateConstructors(aClass);
            for (PsiMethod constructor : constructors) {
                MoveToConstructorFix.addCodeToMethod(initializer, constructor);
            }
            initializer.delete();
        }

        private static void addCodeToMethod(PsiClassInitializer initializer, PsiMethod constructor) {
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return;
            }
            PsiCodeBlock codeBlock = initializer.getBody();
            PsiElement last = codeBlock.getLastBodyElement();
            for (PsiElement element = codeBlock.getFirstBodyElement(); element != null && element != last; element = element.getNextSibling()) {
                body.add(element);
            }
        }

        @NotNull
        private static Collection<PsiMethod> getOrCreateConstructors(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/ClassInitializerInspection$MoveToConstructorFix", "getOrCreateConstructors"));
            }
            Object[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                LocalQuickFixAndIntentionActionOnPsiElement addDefaultConstructorFix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass);
                addDefaultConstructorFix.invoke(aClass.getProject(), null, aClass.getContainingFile());
            }
            constructors = aClass.getConstructors();
            Collection<PsiMethod> collection = MoveToConstructorFix.removeChainedConstructors(ContainerUtil.newArrayList((Object[])constructors));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection$MoveToConstructorFix", "getOrCreateConstructors"));
            }
            return collection;
        }

        @NotNull
        private static Collection<PsiMethod> removeChainedConstructors(@NotNull Collection<PsiMethod> constructors) {
            if (constructors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructors", "com/siyeh/ig/classlayout/ClassInitializerInspection$MoveToConstructorFix", "removeChainedConstructors"));
            }
            Iterator<PsiMethod> iterator = constructors.iterator();
            while (iterator.hasNext()) {
                PsiMethod constructor = iterator.next();
                if (JavaHighlightUtil.getChainedConstructors(constructor) == null) continue;
                iterator.remove();
            }
            Collection<PsiMethod> collection = constructors;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInitializerInspection$MoveToConstructorFix", "removeChainedConstructors"));
            }
            return collection;
        }
    }
}

