/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class EncapsulateVariableFix
extends InspectionGadgetsFix {
    private final String fieldName;

    public EncapsulateVariableFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("encapsulate.variable.quickfix", this.fieldName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EncapsulateVariableFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Encapsulate field" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EncapsulateVariableFix", "getFamilyName"));
        }
        return "Encapsulate field";
    }

    @Override
    public void doFix(final Project project, ProblemDescriptor descriptor) {
        PsiField field;
        PsiElement nameElement = descriptor.getPsiElement();
        PsiElement parent = nameElement.getParent();
        if (parent instanceof PsiField) {
            field = (PsiField)parent;
        } else if (parent instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            field = (PsiField)target;
        } else {
            return;
        }
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        final RefactoringActionHandler renameHandler = factory.createEncapsulateFieldsHandler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                renameHandler.invoke(project, new PsiElement[]{field}, null);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2, project.getDisposed());
        }
    }
}

