/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeClassFinalFix;
import com.siyeh.ig.initialization.OverridableMethodCallDuringObjectConstructionInspectionBase;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class OverridableMethodCallDuringObjectConstructionInspection
extends OverridableMethodCallDuringObjectConstructionInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        PsiClass callClass = ClassUtils.getContainingClass((PsiElement)methodCallExpression);
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection", "buildFixes"));
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !containingClass.equals(callClass) || MethodUtils.isOverridden(method)) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection", "buildFixes"));
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        String methodName = method.getName();
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new MakeClassFinalFix(containingClass), new MakeMethodFinalFix(methodName)};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    private static class MakeMethodFinalFix
    extends InspectionGadgetsFix {
        private final String methodName;

        MakeMethodFinalFix(String methodName) {
            this.methodName = methodName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("make.method.final.fix.name", this.methodName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection$MakeMethodFinalFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Make method final" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection$MakeMethodFinalFix", "getFamilyName"));
            }
            return "Make method final";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiElement methodExpression = methodName.getParent();
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodExpression.getParent();
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return;
            }
            PsiModifierList modifierList = method.getModifierList();
            modifierList.setModifierProperty("final", true);
        }
    }
}

