/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringTokenizerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UseOfStringTokenizer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringTokenizerInspection", "getID"));
        }
        return "UseOfStringTokenizer";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.stringtokenizer.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringTokenizerInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.stringtokenizer.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringTokenizerInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringTokenizerVisitor();
    }

    private static class StringTokenizerVisitor
    extends BaseInspectionVisitor {
        private StringTokenizerVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/internationalization/StringTokenizerInspection$StringTokenizerVisitor", "visitVariable"));
            }
            super.visitVariable(variable);
            PsiType type = variable.getType();
            PsiType deepComponentType = type.getDeepComponentType();
            if (!TypeUtils.typeEquals("java.util.StringTokenizer", deepComponentType)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (StringTokenizerVisitor.isTokenizingNonNlsAnnotatedElement(initializer)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        private static boolean isTokenizingNonNlsAnnotatedElement(PsiExpression initializer) {
            if (!(initializer instanceof PsiNewExpression)) {
                return false;
            }
            PsiNewExpression newExpression = (PsiNewExpression)initializer;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length <= 0) {
                return false;
            }
            return NonNlsUtils.isNonNlsAnnotated(expressions[0]);
        }
    }
}

