/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PackageDotHtmlMayBePackageInfoInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[1]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.exists.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageDotHtmlMayBePackageInfoVisitor();
    }

    private static class PackageDotHtmlMayBePackageInfoVisitor
    extends BaseInspectionVisitor {
        private PackageDotHtmlMayBePackageInfoVisitor() {
        }

        public void visitFile(PsiFile file2) {
            super.visitFile(file2);
            if (!(file2 instanceof XmlFile)) {
                return;
            }
            String fileName = file2.getName();
            if (!"package.html".equals(fileName)) {
                return;
            }
            PsiDirectory directory = file2.getContainingDirectory();
            if (directory == null) {
                return;
            }
            String aPackage = PackageDotHtmlMayBePackageInfoVisitor.getPackage(directory);
            if (aPackage == null) {
                return;
            }
            boolean exists = directory.findFile("package-info.java") != null;
            this.registerError((PsiElement)file2, aPackage, exists);
        }

        public static String getPackage(@NotNull PsiDirectory directory) {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspectionBase$PackageDotHtmlMayBePackageInfoVisitor", "getPackage"));
            }
            VirtualFile virtualFile = directory.getVirtualFile();
            Project project = directory.getProject();
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
            return fileIndex.getPackageNameByDirectory(virtualFile);
        }
    }
}

