/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoBoxingInspection
extends BaseInspection {
    public boolean ignoreAddedToCollection = false;
    @NonNls
    static final Map<String, String> s_boxingClasses = new HashMap<String, String>(8);
    @NonNls
    static final Set<String> convertableBoxedClassNames;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.boxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoBoxingInspection", "getDisplayName"));
        }
        return string;
    }

    public String getAlternativeID() {
        return "boxing";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("auto.boxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoBoxingInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("auto.boxing.ignore.added.to.collection.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAddedToCollection");
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoBoxingVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 0) {
            return null;
        }
        return new AutoBoxingFix();
    }

    static {
        s_boxingClasses.put("byte", "java.lang.Byte");
        s_boxingClasses.put("short", "java.lang.Short");
        s_boxingClasses.put("int", "java.lang.Integer");
        s_boxingClasses.put("long", "java.lang.Long");
        s_boxingClasses.put("float", "java.lang.Float");
        s_boxingClasses.put("double", "java.lang.Double");
        s_boxingClasses.put("boolean", "java.lang.Boolean");
        s_boxingClasses.put("char", "java.lang.Character");
        convertableBoxedClassNames = new HashSet<String>();
        convertableBoxedClassNames.add("java.lang.Byte");
        convertableBoxedClassNames.add("java.lang.Character");
        convertableBoxedClassNames.add("java.lang.Short");
    }

    private class AutoBoxingVisitor
    extends BaseInspectionVisitor {
        private AutoBoxingVisitor() {
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            super.visitArrayAccessExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            super.visitInstanceOfExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            super.visitLiteralExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            super.visitPostfixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            if (expression instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression;
                if (methodReferenceExpression.isConstructor()) {
                    return;
                }
                PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                PsiElement target = methodReferenceExpression.resolve();
                if (!(target instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)target;
                PsiType returnType = method.getReturnType();
                if (returnType == null || returnType.equals(PsiType.VOID) || !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)returnType)) {
                    return;
                }
                PsiPrimitiveType primitiveType = (PsiPrimitiveType)returnType;
                PsiClassType boxedType = primitiveType.getBoxedType((PsiElement)expression);
                if (boxedType == null) {
                    return;
                }
                PsiType functionalInterfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)methodReferenceExpression);
                if (functionalInterfaceReturnType == null || ClassUtils.isPrimitive(functionalInterfaceReturnType) || !functionalInterfaceReturnType.isAssignableFrom((PsiType)boxedType)) {
                    return;
                }
                this.registerError(referenceNameElement, new Object[0]);
            } else {
                this.checkExpression((PsiExpression)expression);
            }
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(@NotNull PsiExpression expression) {
            PsiMethodCallExpression methodCallExpression;
            PsiMethod method;
            PsiElement grandParent;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/jdk/AutoBoxingInspection$AutoBoxingVisitor", "checkExpression"));
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                return;
            }
            if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)grandParent).resolveMethod()) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, Collections.singletonList("java.lang.invoke.MethodHandle.PolymorphicSignature"))) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null || expressionType.equals(PsiType.VOID) || !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expressionType)) {
                return;
            }
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)expressionType;
            PsiClassType boxedType = primitiveType.getBoxedType((PsiElement)expression);
            if (boxedType == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true);
            if (expectedType == null || ClassUtils.isPrimitive(expectedType)) {
                return;
            }
            if (!expectedType.isAssignableFrom((PsiType)boxedType)) {
                if (!(expectedType instanceof PsiClassType) || !PsiUtil.isConstantExpression((PsiExpression)expression)) {
                    return;
                }
                PsiClassType classType = (PsiClassType)expectedType;
                String className = classType.getCanonicalText();
                if (!convertableBoxedClassNames.contains(className)) {
                    return;
                }
                if (!(PsiType.BYTE.equals((Object)expressionType) || PsiType.CHAR.equals((Object)expressionType) || PsiType.SHORT.equals((Object)expressionType) || PsiType.INT.equals((Object)expressionType))) {
                    return;
                }
            }
            if (AutoBoxingInspection.this.ignoreAddedToCollection && this.isAddedToCollection(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean isAddedToCollection(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("put".equals(methodName) || "set".equals(methodName) || "add".equals(methodName))) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Collection", "java.util.Map") != null;
        }
    }

    private static class AutoBoxingFix
    extends InspectionGadgetsFix {
        private AutoBoxingFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("auto.boxing.make.boxing.explicit.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoBoxingInspection$AutoBoxingFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoBoxingInspection$AutoBoxingFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            String classToConstruct;
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true);
            if (expectedType == null) {
                return;
            }
            String expectedTypeText = expectedType.getCanonicalText();
            if (s_boxingClasses.containsValue(expectedTypeText)) {
                classToConstruct = expectedTypeText;
            } else {
                PsiType type = expression.getType();
                if (type == null) {
                    return;
                }
                String expressionTypeText = type.getCanonicalText();
                classToConstruct = s_boxingClasses.get(expressionTypeText);
            }
            if (AutoBoxingFix.shortcutReplace(expression, classToConstruct)) {
                return;
            }
            PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
            if (strippedExpression == null) {
                return;
            }
            String expressionText = strippedExpression.getText();
            String newExpression = "true".equals(expressionText) ? "java.lang.Boolean.TRUE" : ("false".equals(expressionText) ? "java.lang.Boolean.FALSE" : classToConstruct + ".valueOf(" + expressionText + ')');
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, newExpression);
            } else {
                PsiReplacementUtil.replaceExpression(expression, newExpression);
            }
        }

        private static boolean shortcutReplace(PsiExpression expression, String classToConstruct) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return false;
            }
            if (classToConstruct.equals("java.lang.Integer")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Integer", (PsiType)PsiType.INT, "intValue", new PsiType[0])) {
                    expression.replace((PsiElement)qualifierExpression);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Short")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Short", (PsiType)PsiType.SHORT, "shortValue", new PsiType[0])) {
                    expression.replace((PsiElement)qualifierExpression);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Byte")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Byte", (PsiType)PsiType.BYTE, "byteValue", new PsiType[0])) {
                    expression.replace((PsiElement)qualifierExpression);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Character")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Character", (PsiType)PsiType.CHAR, "charValue", new PsiType[0])) {
                    expression.replace((PsiElement)qualifierExpression);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Long")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Long", (PsiType)PsiType.LONG, "longValue", new PsiType[0])) {
                    expression.replace((PsiElement)qualifierExpression);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Float")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Float", (PsiType)PsiType.FLOAT, "floatValue", new PsiType[0])) {
                    expression.replace((PsiElement)qualifierExpression);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Double") && MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Double", (PsiType)PsiType.DOUBLE, "doubleValue", new PsiType[0])) {
                expression.replace((PsiElement)qualifierExpression);
                return true;
            }
            return false;
        }
    }
}

