/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.migration.WhileCanBeForeachInspectionBase;
import com.siyeh.ig.psiutils.StringUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileCanBeForeachInspection
extends WhileCanBeForeachInspectionBase {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new WhileCanBeForeachFix();
    }

    private static class WhileCanBeForeachFix
    extends InspectionGadgetsFix {
        private WhileCanBeForeachFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement whileElement = descriptor.getPsiElement();
            PsiWhileStatement whileStatement = (PsiWhileStatement)whileElement.getParent();
            WhileCanBeForeachFix.replaceWhileWithForEach(whileStatement);
        }

        private static void replaceWhileWithForEach(@NotNull PsiWhileStatement whileStatement) {
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiType collectionType;
            if (whileStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachFix", "replaceWhileWithForEach"));
            }
            PsiStatement body = whileStatement.getBody();
            if (body == null) {
                return;
            }
            PsiStatement initialization = WhileCanBeForeachInspectionBase.getPreviousStatement((PsiElement)whileStatement);
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            if (declaration == null) {
                return;
            }
            PsiElement declaredElement = declaration.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable iterator = (PsiLocalVariable)declaredElement;
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)iterator.getInitializer();
            if (initializer == null) {
                return;
            }
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = methodExpression.getQualifierExpression();
            if (collection == null) {
                PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)whileStatement, PsiClass.class);
                if (aClass == null) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)whileStatement.getProject());
                collectionType = factory.createType(aClass);
            } else {
                collectionType = collection.getType();
            }
            if (collectionType == null) {
                return;
            }
            PsiType contentType = WhileCanBeForeachFix.getContentType(collectionType, "java.lang.Iterable", (PsiElement)whileStatement);
            if (contentType == null) {
                return;
            }
            PsiType iteratorType = iterator.getType();
            PsiType iteratorContentType = WhileCanBeForeachFix.getContentType(iteratorType, "java.util.Iterator", (PsiElement)whileStatement);
            if (iteratorContentType == null) {
                return;
            }
            Project project = whileStatement.getProject();
            PsiStatement firstStatement = WhileCanBeForeachFix.getFirstStatement(body);
            boolean isDeclaration = WhileCanBeForeachFix.isIteratorNextDeclaration(firstStatement, (PsiVariable)iterator, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                if (declarationStatement == null) {
                    return;
                }
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiLocalVariable localVariable = (PsiLocalVariable)declaredElements[0];
                contentVariableName = localVariable.getName();
                statementToSkip = declarationStatement;
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)collection;
                    String collectionName = referenceElement.getReferenceName();
                    contentVariableName = WhileCanBeForeachFix.createNewVariableName(whileStatement, iteratorContentType, collectionName);
                } else {
                    contentVariableName = WhileCanBeForeachFix.createNewVariableName(whileStatement, iteratorContentType, null);
                }
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder();
            out.append("for(");
            if (CodeStyleSettingsManager.getSettings((Project)project).GENERATE_FINAL_PARAMETERS) {
                out.append("final ");
            }
            out.append(iteratorContentType.getCanonicalText()).append(' ').append(contentVariableName).append(": ");
            if (!TypeConversionUtil.isAssignable((PsiType)iteratorContentType, (PsiType)contentType)) {
                out.append("(java.lang.Iterable<").append(iteratorContentType.getCanonicalText()).append(">)");
            }
            if (collection == null) {
                out.append("this");
            } else {
                out.append(collection.getText());
            }
            out.append(')');
            WhileCanBeForeachFix.replaceIteratorNext((PsiElement)body, contentVariableName, (PsiVariable)iterator, contentType, (PsiElement)statementToSkip, out);
            Query query = ReferencesSearch.search((PsiElement)iterator, (SearchScope)iterator.getUseScope());
            boolean deleteIterator = true;
            for (PsiReference usage : query) {
                PsiElement element = usage.getElement();
                if (PsiTreeUtil.isAncestor((PsiElement)whileStatement, (PsiElement)element, (boolean)true)) continue;
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class);
                if (assignment == null) {
                    deleteIterator = false;
                    break;
                }
                PsiExpression expression = assignment.getRExpression();
                initializer.delete();
                iterator.setInitializer(expression);
                PsiElement statement = assignment.getParent();
                PsiElement lastChild = statement.getLastChild();
                if (lastChild instanceof PsiComment) {
                    iterator.add(lastChild);
                }
                statement.replace((PsiElement)iterator);
                break;
            }
            if (deleteIterator) {
                iterator.delete();
            }
            String result2 = out.toString();
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)whileStatement, result2);
        }

        @Nullable
        private static PsiType getContentType(PsiType type, String containerClassName, PsiElement context) {
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            Project project = context.getProject();
            if (aClass == null) {
                return null;
            }
            PsiClass iterableClass = JavaPsiFacade.getInstance((Project)project).findClass(containerClassName, aClass.getResolveScope());
            if (iterableClass == null) {
                return null;
            }
            PsiSubstitutor substitutor1 = resolveResult.getSubstitutor();
            PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)iterableClass, (PsiClass)aClass, (PsiSubstitutor)substitutor1);
            if (substitutor == null) {
                return null;
            }
            PsiType parameterType = substitutor.substitute(iterableClass.getTypeParameters()[0]);
            if (parameterType instanceof PsiCapturedWildcardType) {
                parameterType = ((PsiCapturedWildcardType)parameterType).getWildcard();
            }
            if (parameterType != null) {
                if (parameterType instanceof PsiWildcardType) {
                    if (((PsiWildcardType)parameterType).isExtends()) {
                        return ((PsiWildcardType)parameterType).getBound();
                    }
                    return null;
                }
                return parameterType;
            }
            return TypeUtils.getObjectType(context);
        }

        private static void replaceIteratorNext(@NotNull PsiElement element, String contentVariableName, PsiVariable iterator, PsiType contentType, PsiElement childToSkip, StringBuilder out) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachFix", "replaceIteratorNext"));
            }
            if (WhileCanBeForeachFix.isIteratorNext(element, iterator, contentType)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children2 = element.getChildren();
                if (children2.length == 0) {
                    out.append(element.getText());
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children2) {
                        if (WhileCanBeForeachFix.shouldSkip(iterator, contentType, child)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        WhileCanBeForeachFix.replaceIteratorNext(child, contentVariableName, iterator, contentType, childToSkip, out);
                    }
                }
            }
        }

        private static boolean shouldSkip(PsiVariable iterator, PsiType contentType, PsiElement child) {
            if (!(child instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)child;
            PsiExpression expression = expressionStatement.getExpression();
            return WhileCanBeForeachFix.isIteratorNext((PsiElement)expression, iterator, contentType);
        }

        private static boolean isIteratorNextDeclaration(PsiStatement statement, PsiVariable iterator, PsiType contentType) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] elements = declarationStatement.getDeclaredElements();
            if (elements.length != 1) {
                return false;
            }
            PsiElement element = elements[0];
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)element;
            PsiExpression initializer = variable.getInitializer();
            return WhileCanBeForeachFix.isIteratorNext((PsiElement)initializer, iterator, contentType);
        }

        private static boolean isIteratorNext(PsiElement element, PsiVariable iterator, PsiType contentType) {
            if (element == null) {
                return false;
            }
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)element;
                PsiType type = castExpression.getType();
                if (type == null) {
                    return false;
                }
                if (!type.equals(contentType)) {
                    return false;
                }
                PsiExpression operand = castExpression.getOperand();
                return WhileCanBeForeachFix.isIteratorNext((PsiElement)operand, iterator, contentType);
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return false;
            }
            PsiReferenceExpression reference = callExpression.getMethodExpression();
            String referenceName = reference.getReferenceName();
            if (!"next".equals(referenceName)) {
                return false;
            }
            PsiExpression expression = reference.getQualifierExpression();
            if (!(expression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            return iterator.equals(target);
        }

        private static String createNewVariableName(@NotNull PsiWhileStatement scope, PsiType type, String containerName) {
            String baseName;
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachFix", "createNewVariableName"));
            }
            Project project = scope.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            if (containerName != null) {
                baseName = StringUtils.createSingularFromName(containerName);
            } else {
                SuggestedNameInfo suggestions = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type);
                String[] names = suggestions.names;
                baseName = names != null && names.length > 0 ? names[0] : "value";
            }
            if (baseName == null || baseName.isEmpty()) {
                baseName = "value";
            }
            return codeStyleManager.suggestUniqueVariableName(baseName, (PsiElement)scope, true);
        }

        @Nullable
        private static PsiStatement getFirstStatement(@NotNull PsiStatement body) {
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/migration/WhileCanBeForeachInspection$WhileCanBeForeachFix", "getFirstStatement"));
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = block.getCodeBlock();
                return (PsiStatement)ArrayUtil.getFirstElement((Object[])codeBlock.getStatements());
            }
            return body;
        }
    }
}

