/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceInspection
extends BaseInspection {
    public boolean insideTryAllowed;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("allow.resource.to.be.opened.inside.a.try.block", new Object[0]), (InspectionProfileEntry)this, "insideTryAllowed");
    }

    @Override
    @NotNull
    public final String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/ResourceInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public final BaseInspectionVisitor buildVisitor() {
        return new ResourceVisitor();
    }

    protected abstract boolean isResourceCreation(PsiExpression var1);

    protected boolean isResourceFactoryClosed(PsiExpression expression, boolean insideTryAllowed) {
        return false;
    }

    @Nullable
    public static PsiVariable getVariable(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/resources/ResourceInspection", "getVariable"));
        }
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement referent = referenceExpression.resolve();
            if (!(referent instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)referent;
        }
        if (parent instanceof PsiVariable) {
            return (PsiVariable)parent;
        }
        return null;
    }

    private boolean isSafelyClosed(@Nullable PsiVariable variable, PsiElement context, boolean insideTryAllowed) {
        if (variable == null) {
            return false;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (insideTryAllowed) {
            PsiTryStatement tryStatement;
            PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class);
            while (parentStatement != null && !(parentStatement instanceof PsiTryStatement)) {
                parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, PsiStatement.class);
            }
            if (parentStatement != null && this.isResourceClosedInFinally(tryStatement = (PsiTryStatement)parentStatement, variable)) {
                return true;
            }
        }
        while (nextStatement != null && !ResourceInspection.isSignificant(nextStatement)) {
            nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
        }
        while (nextStatement == null) {
            if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class, (boolean)true)) == null) {
                return false;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                statement = (PsiStatement)parent;
            }
            nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }
        if (!(nextStatement instanceof PsiTryStatement)) {
            return this.isResourceClose(nextStatement, variable);
        }
        PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
        if (this.isResourceClosedInFinally(tryStatement, variable)) {
            return true;
        }
        return this.isResourceClose(nextStatement, variable);
    }

    private static boolean isSignificant(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/resources/ResourceInspection", "isSignificant"));
        }
        final Ref result2 = new Ref((Object)Boolean.TRUE);
        statement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitExpression(PsiExpression expression) {
                super.visitExpression(expression);
                result2.set((Object)Boolean.FALSE);
                this.stopWalking();
            }
        });
        return (Boolean)result2.get() == false;
    }

    boolean isResourceClosedInFinally(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable) {
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/siyeh/ig/resources/ResourceInspection", "isResourceClosedInFinally"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/resources/ResourceInspection", "isResourceClosedInFinally"));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        CloseVisitor visitor = new CloseVisitor(variable);
        finallyBlock.accept((PsiElementVisitor)visitor);
        return visitor.containsClose();
    }

    private boolean isResourceClose(PsiStatement statement, PsiVariable variable) {
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            return this.isResourceClose(methodCallExpression, variable);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return false;
            }
            PsiStatement[] innerStatements = tryBlock.getStatements();
            if (innerStatements.length == 0) {
                return false;
            }
            if (this.isResourceClose(innerStatements[0], variable)) {
                return true;
            }
        } else {
            if (statement instanceof PsiIfStatement) {
                PsiReferenceExpression referenceExpression;
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition = ifStatement.getCondition();
                if (!(condition instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (JavaTokenType.NE != tokenType) {
                    return false;
                }
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return false;
                }
                if (PsiType.NULL.equals((Object)lhs.getType())) {
                    if (!(rhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)rhs;
                    PsiElement target = referenceExpression.resolve();
                    if (!variable.equals(target)) {
                        return false;
                    }
                } else if (PsiType.NULL.equals((Object)rhs.getType())) {
                    if (!(lhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)lhs;
                    PsiElement target = referenceExpression.resolve();
                    if (!variable.equals(target)) {
                        return false;
                    }
                }
                PsiStatement thenBranch = ifStatement.getThenBranch();
                return this.isResourceClose(thenBranch, variable);
            }
            if (statement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                return statements.length != 0 && this.isResourceClose(statements[0], variable);
            }
        }
        return false;
    }

    protected boolean isResourceClose(PsiMethodCallExpression call, PsiVariable resource) {
        return MethodCallUtils.isMethodCallOnVariable(call, resource, "close");
    }

    static boolean isResourceEscapingFromMethod(PsiVariable boundVariable, PsiExpression resourceCreationExpression) {
        PsiClass containingClass;
        PsiField field;
        String fieldName;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiMethodCallExpression methodCallExpression;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        if (resourceCreationExpression instanceof PsiMethodCallExpression && (qualifierExpression = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)resourceCreationExpression).getMethodExpression()).getQualifierExpression()) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiField && ("out".equals(fieldName = (field = (PsiField)target).getName()) || "err".equals(fieldName)) && (containingClass = field.getContainingClass()) != null && "java.lang.System".equals(containingClass.getQualifiedName())) {
            return true;
        }
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)resourceCreationExpression);
        if (parent instanceof PsiConditionalExpression) {
            parent = ParenthesesUtils.getParentSkipParentheses(parent);
        }
        if (parent instanceof PsiReturnStatement) {
            return true;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            if (ParenthesesUtils.stripParentheses(assignmentExpression.getRExpression()) != resourceCreationExpression) {
                return true;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
            if (lhs instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)lhs).resolve()) instanceof PsiField) {
                return true;
            }
        } else if (parent instanceof PsiExpressionList) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiAnonymousClass) {
                grandParent = grandParent.getParent();
            }
            if (grandParent instanceof PsiCallExpression) {
                return true;
            }
        }
        if (boundVariable == null) {
            return false;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)resourceCreationExpression, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (codeBlock == null) {
            return false;
        }
        EscapeVisitor visitor = new EscapeVisitor(boundVariable);
        codeBlock.accept((PsiElementVisitor)visitor);
        return visitor.isEscaped();
    }

    private static class EscapeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable boundVariable;
        private boolean escaped;

        public EscapeVisitor(@NotNull PsiVariable boundVariable) {
            if (boundVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundVariable", "com/siyeh/ig/resources/ResourceInspection$EscapeVisitor", "<init>"));
            }
            this.boundVariable = boundVariable;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
        }

        public void visitElement(PsiElement element) {
            if (this.escaped) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiExpression value = PsiUtil.deparenthesizeExpression((PsiExpression)statement.getReturnValue());
            if (!(value instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value;
            PsiElement target = referenceExpression.resolve();
            if (this.boundVariable.equals(target)) {
                this.escaped = true;
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiExpression rhs = PsiUtil.deparenthesizeExpression((PsiExpression)expression.getRExpression());
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)rhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.boundVariable.equals(target)) {
                return;
            }
            PsiExpression lhs = PsiUtil.deparenthesizeExpression((PsiExpression)expression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression lReferenceExpression = (PsiReferenceExpression)lhs;
            PsiElement lTarget = lReferenceExpression.resolve();
            if (lTarget instanceof PsiField) {
                this.escaped = true;
            }
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            PsiExpression[] expressions;
            PsiExpressionList argumentList = callExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            for (PsiExpression expression : expressions = argumentList.getExpressions()) {
                PsiReferenceExpression referenceExpression;
                PsiElement target;
                PsiExpression expression1 = PsiUtil.deparenthesizeExpression((PsiExpression)expression);
                if (!(expression1 instanceof PsiReferenceExpression) || !this.boundVariable.equals(target = (referenceExpression = (PsiReferenceExpression)expression1).resolve())) continue;
                this.escaped = true;
                break;
            }
        }

        public boolean isEscaped() {
            return this.escaped;
        }
    }

    private class CloseVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsClose;
        private final PsiVariable resource;
        private final String resourceName;

        private CloseVisitor(PsiVariable resource) {
            this.resource = resource;
            this.resourceName = resource.getName();
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/resources/ResourceInspection$CloseVisitor", "visitElement"));
            }
            if (!this.containsClose) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/resources/ResourceInspection$CloseVisitor", "visitMethodCallExpression"));
            }
            if (this.containsClose) {
                return;
            }
            super.visitMethodCallExpression(call);
            if (!ResourceInspection.this.isResourceClose(call, this.resource)) {
                return;
            }
            this.containsClose = true;
        }

        public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
            PsiStatement[] statements;
            super.visitReferenceExpression(referenceExpression);
            if (this.containsClose) {
                return;
            }
            String text = referenceExpression.getText();
            if (text == null || !text.equals(this.resourceName)) {
                return;
            }
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList argumentList = (PsiExpressionList)parent;
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiElement target = referenceExpression.resolve();
            if (target == null || !target.equals(this.resource)) {
                return;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiCodeBlock codeBlock = method.getBody();
            if (codeBlock == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length != 1) {
                return;
            }
            PsiParameter parameter = parameters[0];
            for (PsiStatement statement : statements = codeBlock.getStatements()) {
                if (!ResourceInspection.this.isResourceClose(statement, (PsiVariable)parameter)) continue;
                this.containsClose = true;
                return;
            }
        }

        private boolean containsClose() {
            return this.containsClose;
        }
    }

    private class ResourceVisitor
    extends BaseInspectionVisitor {
        private ResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/resources/ResourceInspection$ResourceVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!this.isNotSafelyClosedResource((PsiExpression)expression)) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/resources/ResourceInspection$ResourceVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            if (!this.isNotSafelyClosedResource((PsiExpression)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        private boolean isNotSafelyClosedResource(PsiExpression expression) {
            if (!ResourceInspection.this.isResourceCreation(expression)) {
                return false;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(expression);
            return !(boundVariable instanceof PsiResourceVariable) && !ResourceInspection.this.isSafelyClosed(boundVariable, (PsiElement)expression, ResourceInspection.this.insideTryAllowed) && !ResourceInspection.this.isResourceFactoryClosed(expression, ResourceInspection.this.insideTryAllowed) && !ResourceInspection.isResourceEscapingFromMethod(boundVariable, expression);
        }
    }
}

