/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileLoopSpinsOnFieldInspection
extends BaseInspection {
    public boolean ignoreNonEmtpyLoops = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("while.loop.spins.on.field.ignore.non.empty.loops.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonEmtpyLoops");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileLoopSpinsOnFieldVisitor();
    }

    private class WhileLoopSpinsOnFieldVisitor
    extends BaseInspectionVisitor {
        private WhileLoopSpinsOnFieldVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$WhileLoopSpinsOnFieldVisitor", "visitWhileStatement"));
            }
            super.visitWhileStatement(statement);
            PsiStatement body = statement.getBody();
            if (WhileLoopSpinsOnFieldInspection.this.ignoreNonEmtpyLoops && !this.statementIsEmpty(body)) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            PsiField field = this.getFieldIfSimpleFieldComparison(condition);
            if (field == null) {
                return;
            }
            if (body != null && (VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)body) || this.containsWaitCall((PsiElement)body))) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private boolean containsWaitCall(PsiElement element) {
            final boolean[] result2 = new boolean[1];
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    super.visitMethodCallExpression(expression);
                    if (ThreadingUtils.isWaitCall(expression)) {
                        result2[0] = true;
                        this.stopWalking();
                    }
                }
            });
            return result2[0];
        }

        @Nullable
        private PsiField getFieldIfSimpleFieldComparison(PsiExpression condition) {
            if ((condition = PsiUtil.deparenthesizeExpression((PsiExpression)condition)) == null) {
                return null;
            }
            PsiField field = this.getFieldIfSimpleFieldAccess(condition);
            if (field != null) {
                return field;
            }
            if (condition instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
                PsiExpression operand = prefixExpression.getOperand();
                return this.getFieldIfSimpleFieldComparison(operand);
            }
            if (condition instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)condition;
                PsiExpression operand = postfixExpression.getOperand();
                return this.getFieldIfSimpleFieldComparison(operand);
            }
            if (condition instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isLiteral(rOperand)) {
                    return this.getFieldIfSimpleFieldComparison(lOperand);
                }
                if (ExpressionUtils.isLiteral(lOperand)) {
                    return this.getFieldIfSimpleFieldComparison(rOperand);
                }
                return null;
            }
            return null;
        }

        @Nullable
        private PsiField getFieldIfSimpleFieldAccess(PsiExpression expression) {
            if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) == null) {
                return null;
            }
            if (!(expression instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression;
            PsiExpression qualifierExpression = reference.getQualifierExpression();
            if (qualifierExpression != null) {
                return null;
            }
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (field.hasModifierProperty("volatile")) {
                return null;
            }
            return field;
        }

        private boolean statementIsEmpty(PsiStatement statement) {
            if (statement == null) {
                return false;
            }
            if (statement instanceof PsiEmptyStatement) {
                return true;
            }
            if (statement instanceof PsiBlockStatement) {
                PsiStatement[] codeBlockStatements;
                PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                for (PsiStatement codeBlockStatement : codeBlockStatements = codeBlock.getStatements()) {
                    if (this.statementIsEmpty(codeBlockStatement)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

