/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.decls;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ipp.base.PsiElementPredicate;

class ChangeVariableTypeToRhsTypePredicate
implements PsiElementPredicate {
    ChangeVariableTypeToRhsTypePredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiTypeElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)parent;
        PsiExpression initializer = variable.getInitializer();
        if (!(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiType type = variable.getType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiType initializerType = initializer.getType();
        if (!(initializerType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType initializerClassType = (PsiClassType)initializerType;
        PsiClass initializerClass = initializerClassType.resolve();
        if (initializerClass instanceof PsiAnonymousClass) {
            initializerClass = initializerClass.getSuperClass();
        }
        if (initializerClass == null) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass variableClass = classType.resolve();
        if (variableClass == null) {
            return false;
        }
        if (variableClass.equals(initializerClass)) {
            return false;
        }
        return initializerClass.isInheritor(variableClass, true);
    }
}

