/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class IfToSwitchPredicate
implements PsiElementPredicate {
    IfToSwitchPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.IF_KEYWORD) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement statement = (PsiIfStatement)parent;
        if (ErrorUtil.containsError((PsiElement)statement)) {
            return false;
        }
        return SwitchUtils.getSwitchExpression(statement, 0) != null;
    }
}

