/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.model.Define;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OverridingDefineRenderer
extends GutterIconRenderer
implements DumbAware {
    private final Set<Define> mySet;
    private final String myMessage;

    public OverridingDefineRenderer(String message, Set<Define> set) {
        this.mySet = set;
        this.myMessage = message;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.OverridingMethod;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/annotation/OverridingDefineRenderer", "getIcon"));
        }
        return icon;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public AnAction getClickAction() {
        return new MyClickAction();
    }

    @Nullable
    public String getTooltipText() {
        return this.myMessage;
    }

    static void doClickAction(AnActionEvent e, Collection<Define> set, String title) {
        if (set.size() == 1) {
            Navigatable n = (Navigatable)set.iterator().next().getPsiElement();
            OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{n});
        } else {
            Object[] array = set.toArray(new Define[set.size()]);
            NavigationUtil.getPsiElementPopup((PsiElement[])ContainerUtil.map((Object[])array, (Function)new Function<Define, PsiElement>(){

                public PsiElement fun(Define define) {
                    return define.getPsiElement();
                }
            }, (Object[])PsiElement.EMPTY_ARRAY), title).show(new RelativePoint((MouseEvent)e.getInputEvent()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OverridingDefineRenderer that = (OverridingDefineRenderer)((Object)o);
        if (this.myMessage != null ? !this.myMessage.equals(that.myMessage) : that.myMessage != null) {
            return false;
        }
        return !(this.mySet != null ? !this.mySet.equals(that.mySet) : that.mySet != null);
    }

    public int hashCode() {
        int result2 = this.mySet != null ? this.mySet.hashCode() : 0;
        result2 = 31 * result2 + (this.myMessage != null ? this.myMessage.hashCode() : 0);
        return result2;
    }

    private class MyClickAction
    extends AnAction {
        private MyClickAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            OverridingDefineRenderer.doClickAction(e, OverridingDefineRenderer.this.mySet, "Go to overridden define");
        }
    }
}

