/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.OpenFileHttpService;

class OpenFileXmlRpcHandler {
    private static final Logger LOG = Logger.getInstance(OpenFileXmlRpcHandler.class);

    OpenFileXmlRpcHandler() {
    }

    public boolean open(String path) {
        LOG.debug("open(" + path + ")");
        return OpenFileXmlRpcHandler.doOpen(path, -1, -1);
    }

    public boolean openAndNavigate(String path, int line, int column) {
        LOG.debug("openAndNavigate(" + path + ", " + line + ", " + column + ")");
        return OpenFileXmlRpcHandler.doOpen(path, line, column);
    }

    private static boolean doOpen(@NotNull String path, int line, int column) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/ide/OpenFileXmlRpcHandler", "doOpen"));
        }
        OpenFileHttpService.OpenFileRequest request = new OpenFileHttpService.OpenFileRequest();
        request.file = path;
        request.line = line;
        request.column = column;
        request.focused = false;
        return ((OpenFileHttpService)((Object)HttpRequestHandler.EP_NAME.findExtension(OpenFileHttpService.class))).openFile(request).getState() != Promise.State.REJECTED;
    }
}

