/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.PortUnificationServerHandler;

public class BuiltInServer
implements Disposable {
    private static final int[] FORBIDDEN_PORTS = new int[]{6953, 6969, 6970};
    private final EventLoopGroup eventLoopGroup;
    private final int port;
    private final ChannelRegistrar channelRegistrar;
    private final boolean isOwnerOfEventLoopGroup;

    private BuiltInServer(@NotNull EventLoopGroup eventLoopGroup, int port, @NotNull ChannelRegistrar channelRegistrar, boolean isOwnerOfEventLoopGroup) {
        if (eventLoopGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLoopGroup", "org/jetbrains/io/BuiltInServer", "<init>"));
        }
        if (channelRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelRegistrar", "org/jetbrains/io/BuiltInServer", "<init>"));
        }
        this.eventLoopGroup = eventLoopGroup;
        this.port = port;
        this.channelRegistrar = channelRegistrar;
        this.isOwnerOfEventLoopGroup = isOwnerOfEventLoopGroup;
    }

    @NotNull
    public EventLoopGroup getEventLoopGroup() {
        EventLoopGroup eventLoopGroup = this.eventLoopGroup;
        if (eventLoopGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/BuiltInServer", "getEventLoopGroup"));
        }
        return eventLoopGroup;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return !this.channelRegistrar.isEmpty();
    }

    public void dispose() {
        this.channelRegistrar.close(this.isOwnerOfEventLoopGroup);
        Logger.getInstance(BuiltInServer.class).info("web server stopped");
    }

    @NotNull
    public static BuiltInServer start(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<ChannelHandler> handler2) throws Exception {
        BuiltInServer builtInServer = BuiltInServer.start((EventLoopGroup)new NioEventLoopGroup(workerCount, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Netty Builtin Server " + this.counter.incrementAndGet());
            }
        }), true, firstPort, portsCount, tryAnyPort, handler2);
        if (builtInServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/BuiltInServer", "start"));
        }
        return builtInServer;
    }

    @NotNull
    public static BuiltInServer start(@NotNull EventLoopGroup eventLoopGroup, boolean isEventLoopGroupOwner, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<ChannelHandler> handler2) throws Exception {
        if (eventLoopGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLoopGroup", "org/jetbrains/io/BuiltInServer", "start"));
        }
        ChannelRegistrar channelRegistrar = new ChannelRegistrar();
        ServerBootstrap bootstrap = NettyUtil.nioServerBootstrap(eventLoopGroup);
        BuiltInServer.configureChildHandler(bootstrap, channelRegistrar, handler2);
        int port = BuiltInServer.bind(firstPort, portsCount, tryAnyPort, bootstrap, channelRegistrar);
        BuiltInServer builtInServer = new BuiltInServer(eventLoopGroup, port, channelRegistrar, isEventLoopGroupOwner);
        if (builtInServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/BuiltInServer", "start"));
        }
        return builtInServer;
    }

    static void configureChildHandler(@NotNull ServerBootstrap bootstrap, final @NotNull ChannelRegistrar channelRegistrar, final @Nullable NotNullProducer<ChannelHandler> channelHandler) {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/BuiltInServer", "configureChildHandler"));
        }
        if (channelRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelRegistrar", "org/jetbrains/io/BuiltInServer", "configureChildHandler"));
        }
        final PortUnificationServerHandler portUnificationServerHandler = channelHandler == null ? new PortUnificationServerHandler() : null;
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(@NotNull Channel channel) throws Exception {
                if (channel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/BuiltInServer$2", "initChannel"));
                }
                channel.pipeline().addLast(new ChannelHandler[]{channelRegistrar, channelHandler == null ? portUnificationServerHandler : (ChannelHandler)channelHandler.produce()});
            }
        });
    }

    private static int bind(int firstPort, int portsCount, boolean tryAnyPort, @NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar) throws Exception {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/BuiltInServer", "bind"));
        }
        if (channelRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelRegistrar", "org/jetbrains/io/BuiltInServer", "bind"));
        }
        InetAddress address = NetUtils.getLoopbackAddress();
        for (int i = 0; i < portsCount; ++i) {
            int port = firstPort + i;
            if (ArrayUtil.indexOf((int[])FORBIDDEN_PORTS, (int)i) >= 0) continue;
            ChannelFuture future2 = bootstrap.bind(address, port).awaitUninterruptibly();
            if (future2.isSuccess()) {
                channelRegistrar.add(future2.channel());
                return port;
            }
            if (tryAnyPort || i != portsCount - 1) continue;
            ExceptionUtil.rethrowAll((Throwable)future2.cause());
        }
        Logger.getInstance(BuiltInServer.class).info("We cannot bind to our default range, so, try to bind to any free port");
        ChannelFuture future3 = bootstrap.bind(address, 0).awaitUninterruptibly();
        if (future3.isSuccess()) {
            channelRegistrar.add(future3.channel());
            return ((InetSocketAddress)future3.channel().localAddress()).getPort();
        }
        ExceptionUtil.rethrowAll((Throwable)future3.cause());
        return -1;
    }

    public static void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/BuiltInServer", "replaceDefaultHandler"));
        }
        if (channelHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelHandler", "org/jetbrains/io/BuiltInServer", "replaceDefaultHandler"));
        }
        context.pipeline().replace(DelegatingHttpRequestHandler.class, "replacedDefaultHandler", channelHandler);
    }
}

