/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc.socket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.nio.channels.ClosedChannelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;

public class SocketClient
extends Client {
    protected SocketClient(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/jsonRpc/socket/SocketClient", "<init>"));
        }
        super(channel);
    }

    @Override
    public ChannelFuture send(@NotNull ByteBuf message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/jsonRpc/socket/SocketClient", "send"));
        }
        if (this.channel.isOpen()) {
            ByteBuf lengthBuffer = this.channel.alloc().buffer(4);
            lengthBuffer.writeInt(message.readableBytes());
            this.channel.write((Object)lengthBuffer);
            return this.channel.writeAndFlush((Object)message);
        }
        return this.channel.newFailedFuture((Throwable)new ClosedChannelException());
    }

    @Override
    public void sendHeartbeat() {
    }
}

