/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.lang.manifest.psi.ManifestToken;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class HeaderValuePartImpl
extends ASTWrapperPsiElement
implements HeaderValuePart {
    private static final TokenSet SPACES = TokenSet.create((IElementType[])new IElementType[]{ManifestTokenType.SIGNIFICANT_SPACE, ManifestTokenType.NEWLINE});
    private final HeaderParserRepository myRepository = (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);

    public HeaderValuePartImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getUnwrappedText().isEmpty() ? PsiReference.EMPTY_ARRAY : this.myRepository.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/psi/impl/HeaderValuePartImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public String getUnwrappedText() {
        StringBuilder builder = new StringBuilder();
        for (PsiElement element = this.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (HeaderValuePartImpl.isSpace(element)) continue;
            builder.append(element.getText());
        }
        String string = builder.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/psi/impl/HeaderValuePartImpl", "getUnwrappedText"));
        }
        return string;
    }

    @Override
    @NotNull
    public TextRange getHighlightingRange() {
        int endOffset = this.getTextRange().getEndOffset();
        PsiElement last = this.getLastChild();
        while (HeaderValuePartImpl.isSpace(last)) {
            endOffset -= last.getTextLength();
            last = last.getPrevSibling();
        }
        int startOffset = this.getTextOffset();
        PsiElement first = this.getFirstChild();
        while (startOffset < endOffset && HeaderValuePartImpl.isSpace(first)) {
            startOffset += first.getTextLength();
            first = first.getNextSibling();
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/psi/impl/HeaderValuePartImpl", "getHighlightingRange"));
        }
        return textRange;
    }

    @Override
    public String toString() {
        return "HeaderValuePart";
    }

    private static boolean isSpace(PsiElement element) {
        return element instanceof ManifestToken && SPACES.contains((IElementType)((ManifestToken)element).getTokenType());
    }
}

