/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.jetbrains.idea.maven.indices.MavenClassSearchResult;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;

public class MavenClassSearcher
extends MavenSearcher<MavenClassSearchResult> {
    public static final String TERM = "c";

    @Override
    protected Pair<String, Query> preparePatternAndQuery(String pattern) {
        if ((pattern = pattern.toLowerCase()).trim().length() == 0) {
            return new Pair((Object)pattern, (Object)new MatchAllDocsQuery());
        }
        List parts = StringUtil.split((String)pattern, (String)".");
        StringBuilder newPattern = new StringBuilder();
        for (int i = 0; i < parts.size() - 1; ++i) {
            String each = (String)parts.get(i);
            newPattern.append(each.trim());
            newPattern.append("*.");
        }
        String className = (String)parts.get(parts.size() - 1);
        boolean exactSearch = className.endsWith(" ");
        newPattern.append(className.trim());
        if (!exactSearch) {
            newPattern.append("*");
        }
        pattern = newPattern.toString();
        String queryPattern = "*/" + pattern.replaceAll("\\.", "/");
        return new Pair((Object)pattern, (Object)new WildcardQuery(new Term(TERM, queryPattern)));
    }

    @Override
    protected Collection<MavenClassSearchResult> processResults(Set<MavenArtifactInfo> infos, String pattern, int maxResult) {
        Pattern p;
        if (pattern.length() == 0 || pattern.equals("*")) {
            pattern = "^/(.*)$";
        } else {
            int lastDot = (pattern = pattern.replace(".", "/")).lastIndexOf("/");
            String packagePattern = lastDot == -1 ? "" : pattern.substring(0, lastDot) + "/";
            String classNamePattern = lastDot == -1 ? pattern : pattern.substring(lastDot + 1);
            packagePattern = packagePattern.replaceAll("\\*", ".*?");
            classNamePattern = classNamePattern.replaceAll("\\*", "[^/]*?");
            pattern = packagePattern + classNamePattern;
            pattern = ".*?/" + pattern;
            pattern = "^(" + pattern + ")$";
        }
        try {
            p = Pattern.compile(pattern, 10);
        }
        catch (PatternSyntaxException e) {
            return Collections.emptyList();
        }
        THashMap result = new THashMap();
        block2: for (MavenArtifactInfo each : infos) {
            if (each.getClassNames() == null) continue;
            Matcher matcher = p.matcher(each.getClassNames());
            while (matcher.find()) {
                String key;
                MavenClassSearchResult classResult;
                String classFQName = matcher.group(1);
                if ((classFQName = classFQName.replace("/", ".")).startsWith(".")) {
                    classFQName = classFQName.substring(1);
                }
                if ((classResult = (MavenClassSearchResult)result.get(key = this.makeKey(classFQName, each))) == null) {
                    classResult = new MavenClassSearchResult();
                    int pos = classFQName.lastIndexOf(".");
                    if (pos == -1) {
                        classResult.packageName = "default package";
                        classResult.className = classFQName;
                    } else {
                        classResult.packageName = classFQName.substring(0, pos);
                        classResult.className = classFQName.substring(pos + 1);
                    }
                    result.put(key, classResult);
                }
                classResult.versions.add(each);
                if (result.size() <= maxResult) continue;
                continue block2;
            }
        }
        return result.values();
    }

    @Override
    protected String makeSortKey(MavenClassSearchResult result) {
        return this.makeKey(result.className, (MavenArtifactInfo)result.versions.get(0));
    }

    private String makeKey(String className, MavenArtifactInfo info) {
        return className + " " + super.makeKey(info);
    }
}

