/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.PreconditionsKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuiltinSpecialProperties {
    private static final Map<FqName, Name> PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP;
    private static final Map<Name, List<Name>> GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP;
    private static final Set<FqName> FQ_NAMES;
    @NotNull
    public static final Set<Name> SHORT_NAMES;
    public static final BuiltinSpecialProperties INSTANCE;
    public static final BuiltinSpecialProperties INSTANCE$;

    @NotNull
    public final Set<Name> getSHORT_NAMES$kotlin_core() {
        return SHORT_NAMES;
    }

    public final boolean hasBuiltinSpecialPropertyFqName(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkParameterIsNotNull(callableMemberDescriptor, "callableMemberDescriptor");
        if (SHORT_NAMES.contains(callableMemberDescriptor.getName()) ^ true) {
            return false;
        }
        return this.hasBuiltinSpecialPropertyFqNameImpl(callableMemberDescriptor);
    }

    private final boolean hasBuiltinSpecialPropertyFqNameImpl(CallableMemberDescriptor $receiver) {
        boolean bl;
        block3: {
            if (CollectionsKt.contains((Iterable)FQ_NAMES, DescriptorUtilsKt.fqNameOrNull($receiver))) {
                return true;
            }
            if (!SpecialBuiltinMembers.isFromBuiltins($receiver)) {
                return false;
            }
            Iterable $receiver$iv = $receiver.getOverriddenDescriptors();
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor it;
                CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                if (!INSTANCE.hasBuiltinSpecialPropertyFqName(callableMemberDescriptor)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<Name> getPropertyNameCandidatesBySpecialGetterName(@NotNull Name name1) {
        Intrinsics.checkParameterIsNotNull(name1, "name1");
        List<Name> list = GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP.get(name1);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final String getBuiltinSpecialPropertyGetterName(CallableMemberDescriptor $receiver) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        boolean value$iv = SpecialBuiltinMembers.isFromBuiltins($receiver);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "This method is defined only for builtin members, but " + $receiver + " found";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtilsKt.firstOverridden(DescriptorUtilsKt.getPropertyIfAccessor($receiver), getBuiltinSpecialPropertyGetterName.descriptor.1.INSTANCE);
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        Name name = PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP.get(DescriptorUtilsKt.getFqNameSafe(descriptor2));
        return name != null ? name.asString() : null;
    }

    /*
     * WARNING - void declaration
     */
    private BuiltinSpecialProperties() {
        void var3_3;
        void $receiver$iv$iv;
        INSTANCE = this;
        INSTANCE$ = this;
        PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP = MapsKt.mapOf(TuplesKt.to(new FqName("kotlin.Enum.name"), Name.identifier("name")), TuplesKt.to(new FqName("kotlin.Enum.ordinal"), Name.identifier("ordinal")), TuplesKt.to(new FqName("kotlin.Collection.size"), Name.identifier("size")), TuplesKt.to(new FqName("kotlin.Map.size"), Name.identifier("size")), TuplesKt.to(new FqName("kotlin.CharSequence.length"), Name.identifier("length")), TuplesKt.to(new FqName("kotlin.Map.keys"), Name.identifier("keySet")), TuplesKt.to(new FqName("kotlin.Map.values"), Name.identifier("values")), TuplesKt.to(new FqName("kotlin.Map.entries"), Name.identifier("entrySet")));
        GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP = SpecialBuiltinMembers.access$getInversedShortNamesMap(PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP);
        Object $receiver$iv = PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP;
        FQ_NAMES = $receiver$iv.keySet();
        $receiver$iv = FQ_NAMES;
        Object $i$f$keySet = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            Name name = it.shortName();
            collection.add(name);
        }
        SHORT_NAMES = CollectionsKt.toSet((List)var3_3);
    }

    static {
        new BuiltinSpecialProperties();
    }
}

