/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManagerQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.BranchesLoader;
import org.jetbrains.idea.svn.branchConfig.DefaultBranchConfigInitializer;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class NewRootBunch {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.NewRootBunch");
    private final Object myLock = new Object();
    private final Project myProject;
    private final ProgressManagerQueue myBranchesLoader;
    private final Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> myMap;

    public NewRootBunch(Project project, ProgressManagerQueue branchesLoader) {
        this.myProject = project;
        this.myBranchesLoader = branchesLoader;
        this.myMap = new HashMap<VirtualFile, InfoStorage<SvnBranchConfigurationNew>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForRoot(final @NotNull VirtualFile root, final @NotNull InfoStorage<SvnBranchConfigurationNew> config, boolean reload) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateForRoot"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateForRoot"));
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean override;
            SvnBranchConfigurationNew previous;
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                previous = null;
                override = true;
                this.myMap.put(root, config);
            } else {
                previous = existing.getValue();
                override = existing.accept(config);
            }
            if (reload && override) {
                this.myBranchesLoader.run((Object)new Runnable(){

                    @Override
                    public void run() {
                        NewRootBunch.this.reloadBranches(root, previous, (SvnBranchConfigurationNew)config.getValue());
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBranches(@NotNull VirtualFile root, @NotNull String branchesParent, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateBranches"));
        }
        if (branchesParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchesParent", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateBranches"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateBranches"));
        }
        Object object = this.myLock;
        synchronized (object) {
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                LOG.info("cannot update branches, branches parent not found: " + branchesParent);
            } else {
                existing.getValue().updateBranch(branchesParent, items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public SvnBranchConfigurationNew getConfig(@NotNull VirtualFile root) {
        SvnBranchConfigurationNew result;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "getConfig"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        InfoStorage<SvnBranchConfigurationNew> value = this.myMap.get(root);
        if (value == null) {
            result = new SvnBranchConfigurationNew();
            this.myMap.put(root, new InfoStorage<SvnBranchConfigurationNew>(result, InfoReliability.empty));
            this.myBranchesLoader.run((Object)new DefaultBranchConfigInitializer(this.myProject, this, root));
        } else {
            result = value.getValue();
        }
        SvnBranchConfigurationNew svnBranchConfigurationNew = result;
        // MONITOREXIT : object
        if (svnBranchConfigurationNew != null) return svnBranchConfigurationNew;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "getConfig"));
    }

    public void reloadBranchesAsync(final @NotNull VirtualFile root, final @NotNull String branchLocation, final @NotNull InfoReliability reliability) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranchesAsync"));
        }
        if (branchLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchLocation", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranchesAsync"));
        }
        if (reliability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reliability", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranchesAsync"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                NewRootBunch.this.reloadBranches(root, branchLocation, reliability, true);
            }
        });
    }

    public void reloadBranches(@NotNull VirtualFile root, @Nullable SvnBranchConfigurationNew prev, @NotNull SvnBranchConfigurationNew next) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranches"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranches"));
        }
        HashSet<String> oldUrls = prev == null ? Collections.emptySet() : new HashSet<String>(prev.getBranchUrls());
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
            return;
        }
        for (String newBranchUrl : next.getBranchUrls()) {
            if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
                return;
            }
            if (oldUrls.contains(newBranchUrl)) continue;
            this.reloadBranches(root, newBranchUrl, InfoReliability.defaultValues, true);
        }
    }

    public void reloadBranches(@NotNull VirtualFile root, @NotNull String branchLocation, @NotNull InfoReliability reliability, boolean passive) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranches"));
        }
        if (branchLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchLocation", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranches"));
        }
        if (reliability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reliability", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranches"));
        }
        new BranchesLoader(this.myProject, this, branchLocation, reliability, root, passive).run();
    }

    @Nullable
    public SVNURL getWorkingBranch(@NotNull SVNURL svnurl, @NotNull VirtualFile root) {
        SVNURL result;
        if (svnurl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnurl", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "getWorkingBranch"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "getWorkingBranch"));
        }
        try {
            result = this.myMap.get(root).getValue().getWorkingBranch(svnurl);
        }
        catch (SvnBindException e) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<VirtualFile, SvnBranchConfigurationNew> getMapCopy() {
        Object object = this.myLock;
        synchronized (object) {
            HashMap<VirtualFile, SvnBranchConfigurationNew> result = new HashMap<VirtualFile, SvnBranchConfigurationNew>();
            for (VirtualFile vf : this.myMap.keySet()) {
                result.put(vf, this.myMap.get(vf).getValue());
            }
            return result;
        }
    }
}

