/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.MarkerVcsContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.vcsUtil.VcsUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.SvnRepositoryBinaryContentRevision;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnRepositoryContentRevision
implements ContentRevision,
MarkerVcsContentRevision {
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final String myPath;
    @NotNull
    private final FilePath myFilePath;
    private final long myRevision;

    public SvnRepositoryContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath remotePath, @Nullable FilePath localPath, long revision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "<init>"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "<init>"));
        }
        this.myVcs = vcs;
        this.myPath = FileUtil.toSystemIndependentName((String)remotePath.getPath());
        this.myFilePath = localPath != null ? localPath : remotePath;
        this.myRevision = revision;
    }

    @Nullable
    public String getContent() throws VcsException {
        try {
            if (this.myFilePath.getVirtualFile() == null) {
                LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myFilePath.getPath());
            }
            return ContentRevisionCache.getOrLoadAsString((Project)this.myVcs.getProject(), (FilePath)this.myFilePath, (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVcs.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, (Throwable2Computable)new Throwable2Computable<byte[], VcsException, IOException>(){

                public byte[] compute() throws VcsException, IOException {
                    return SvnRepositoryContentRevision.this.loadContent().toByteArray();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    protected ByteArrayOutputStream loadContent() throws VcsException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ContentLoader loader = new ContentLoader(this.myPath, buffer, this.myRevision);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, null);
        } else {
            loader.run();
        }
        Exception exception = loader.getException();
        if (exception != null) {
            throw new VcsException((Throwable)exception);
        }
        ContentRevisionCache.checkContentsSize((String)this.myPath, (long)buffer.size());
        ByteArrayOutputStream byteArrayOutputStream = buffer;
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "loadContent"));
        }
        return byteArrayOutputStream;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public SvnRevisionNumber getRevisionNumber() {
        SvnRevisionNumber svnRevisionNumber = new SvnRevisionNumber(SVNRevision.create((long)this.myRevision));
        if (svnRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "getRevisionNumber"));
        }
        return svnRevisionNumber;
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull String repositoryRoot, @NotNull String path, @Nullable FilePath localPath, long revision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "create"));
        }
        if (repositoryRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryRoot", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "create"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "create"));
        }
        return SvnRepositoryContentRevision.create(vcs, SvnUtil.appendMultiParts(repositoryRoot, path), localPath, revision);
    }

    public static SvnRepositoryContentRevision createForRemotePath(@NotNull SvnVcs vcs, @NotNull String repositoryRoot, @NotNull String path, boolean isDirectory, long revision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "createForRemotePath"));
        }
        if (repositoryRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryRoot", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "createForRemotePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "createForRemotePath"));
        }
        FilePath remotePath = VcsUtil.getFilePathOnNonLocal((String)SvnUtil.appendMultiParts(repositoryRoot, path), (boolean)isDirectory);
        return SvnRepositoryContentRevision.create(vcs, remotePath, remotePath, revision);
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull String fullPath, @Nullable FilePath localPath, long revision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "create"));
        }
        if (fullPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullPath", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "create"));
        }
        FilePath remotePath = VcsUtil.getFilePathOnNonLocal((String)fullPath, (boolean)false);
        return SvnRepositoryContentRevision.create(vcs, remotePath, localPath == null ? remotePath : localPath, revision);
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull FilePath remotePath, @Nullable FilePath localPath, long revision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "create"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "create"));
        }
        return remotePath.getFileType().isBinary() ? new SvnRepositoryBinaryContentRevision(vcs, remotePath, localPath, revision) : new SvnRepositoryContentRevision(vcs, remotePath, localPath, revision);
    }

    public String toString() {
        return this.myFilePath.getIOFile() + "#" + this.myRevision;
    }

    @NotNull
    public String getFullPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "getFullPath"));
        }
        return string;
    }

    public String getRelativePath(@NotNull String repositoryUrl) {
        if (repositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryUrl", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "getRelativePath"));
        }
        return SvnUtil.getRelativePath(repositoryUrl, this.myPath);
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }

    @NotNull
    public SvnTarget toTarget() throws SvnBindException {
        SvnTarget svnTarget = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(this.getFullPath()), (SVNRevision)this.getRevisionNumber().getRevision());
        if (svnTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnRepositoryContentRevision", "toTarget"));
        }
        return svnTarget;
    }

    private class ContentLoader
    implements Runnable {
        private final String myPath;
        private final long myRevision;
        private final OutputStream myDst;
        private Exception myException;

        public ContentLoader(String path, OutputStream dst, long revision) {
            this.myPath = path;
            this.myDst = dst;
            this.myRevision = revision;
        }

        public Exception getException() {
            return this.myException;
        }

        @Override
        public void run() {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.loading.contents", this.myPath));
                progress.setText2(SvnBundle.message("progress.text2.revision.information", this.myRevision));
            }
            try {
                SVNRevision revision = SVNRevision.create((long)this.myRevision);
                byte[] contents = SvnUtil.getFileContents(SvnRepositoryContentRevision.this.myVcs, SvnTarget.fromURL((SVNURL)SvnUtil.parseUrl(SvnRepositoryContentRevision.this.getFullPath())), revision, revision);
                this.myDst.write(contents);
            }
            catch (VcsException e) {
                this.myException = e;
            }
            catch (IOException e) {
                this.myException = e;
            }
        }
    }
}

