/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.util.Comparator;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.StatEntry;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SortOption {
    NONE,
    SORT_BY_NAME,
    SORT_BY_NAME_DESC,
    SORT_BY_CLASS,
    SORT_BY_CLASS_DESC,
    SORT_BY_METHOD,
    SORT_BY_METHOD_DESC,
    SORT_BY_BLOCK,
    SORT_BY_BLOCK_DESC,
    SORT_BY_LINE,
    SORT_BY_LINE_DESC,
    SORT_BY_STATEMENT,
    SORT_BY_STATEMENT_DESC;


    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getIndexFileName() {
        if (this == SORT_BY_NAME) return "index.html";
        if (this == NONE) {
            return "index.html";
        }
        String string = "index_" + this.name() + ".html";
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/SortOption.getIndexFileName must not return null");
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SortOption inverse() {
        SortOption sortOption;
        block14: {
            switch (this) {
                default: {
                    sortOption = NONE;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_BLOCK: {
                    sortOption = SORT_BY_BLOCK_DESC;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_BLOCK_DESC: {
                    sortOption = SORT_BY_BLOCK;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_NAME: {
                    sortOption = SORT_BY_NAME_DESC;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_NAME_DESC: {
                    sortOption = SORT_BY_NAME;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_CLASS: {
                    sortOption = SORT_BY_CLASS_DESC;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_CLASS_DESC: {
                    sortOption = SORT_BY_CLASS;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_METHOD: {
                    sortOption = SORT_BY_METHOD_DESC;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_METHOD_DESC: {
                    sortOption = SORT_BY_METHOD;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_LINE: {
                    sortOption = SORT_BY_LINE_DESC;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_LINE_DESC: {
                    sortOption = SORT_BY_LINE;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_STATEMENT: {
                    sortOption = SORT_BY_STATEMENT_DESC;
                    if (sortOption == null) break;
                    return sortOption;
                }
                case SORT_BY_STATEMENT_DESC: {
                    sortOption = SORT_BY_STATEMENT;
                    if (sortOption != null) break block14;
                }
            }
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/SortOption.inverse must not return null");
        }
        return sortOption;
    }

    public boolean isDescendingOrder() {
        return this.name().endsWith("_DESC");
    }

    public Comparator<ClassInfo> createClassComparator(final StatisticsCalculator covStatsCalculator) {
        final boolean desc = this.isDescendingOrder();
        if (this.orderByName()) {
            return new Comparator<ClassInfo>(){

                @Override
                public int compare(ClassInfo o1, ClassInfo o2) {
                    int result = o1.getName().compareTo(o2.getName());
                    return desc ? -result : result;
                }
            };
        }
        return this.comparator(new Func<ClassInfo>(){

            @Override
            public CoverageStatistics compute(ClassInfo classInfo) {
                return covStatsCalculator.getForClassWithInnerClasses(classInfo);
            }
        });
    }

    public Comparator<String> createNamespaceComparator(ModuleInfo module, final StatisticsCalculator covStatsCalculator) {
        final boolean desc = this.isDescendingOrder();
        final String moduleName = module.getName();
        if (this.orderByName()) {
            return new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int result = o1.compareTo(o2);
                    return desc ? -result : result;
                }
            };
        }
        return this.comparator(new Func<String>(){

            @Override
            public CoverageStatistics compute(String s) {
                return covStatsCalculator.getForNamespace(moduleName, s);
            }
        });
    }

    public Comparator<ModuleInfo> createModulesComparator(final StatisticsCalculator covStatsCalculator) {
        if (this.orderByName()) {
            return new Comparator<ModuleInfo>(){

                @Override
                public int compare(ModuleInfo o1, ModuleInfo o2) {
                    String n1 = o1.getName();
                    String n2 = o2.getName();
                    if (n1 == null && n2 == null) {
                        return 0;
                    }
                    if (n1 != null && n2 == null) {
                        return 1;
                    }
                    if (n1 == null && n2 != null) {
                        return -1;
                    }
                    int result = n1.compareTo(n2);
                    return SortOption.this.isDescendingOrder() ? -result : result;
                }
            };
        }
        return this.comparator(new Func<ModuleInfo>(){

            @Override
            public CoverageStatistics compute(ModuleInfo moduleInfo) {
                return covStatsCalculator.getForModule(moduleInfo.getName());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Selector getSelector() {
        Selector selector;
        if (this.orderByMethod()) {
            selector = new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    if (stat == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/SortOption$7.compute must not be null");
                    }
                    return stat.getMethodStats();
                }
            };
            if (selector == null) throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/SortOption.getSelector must not return null");
            return selector;
        }
        if (this.orderByBlock()) {
            selector = new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    if (stat == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/SortOption$8.compute must not be null");
                    }
                    return stat.getBlockStats();
                }
            };
            if (selector == null) throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/SortOption.getSelector must not return null");
            return selector;
        }
        if (this.orderByStatement()) {
            selector = new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    if (stat == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/SortOption$9.compute must not be null");
                    }
                    return stat.getStatementStats();
                }
            };
            if (selector == null) throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/SortOption.getSelector must not return null");
            return selector;
        }
        if (this.orderByLine()) {
            selector = new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    if (stat == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/SortOption$10.compute must not be null");
                    }
                    return stat.getLineStats();
                }
            };
            if (selector == null) throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/SortOption.getSelector must not return null");
            return selector;
        }
        if (!this.orderByClass()) {
            throw new IllegalArgumentException("Failed to get statistics selector for: " + (Object)((Object)this));
        }
        selector = new Selector(){

            public StatEntry compute(@NotNull CoverageStatistics stat) {
                if (stat == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/SortOption$11.compute must not be null");
                }
                return stat.getClassStats();
            }
        };
        if (selector != null) return selector;
        throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/SortOption.getSelector must not return null");
    }

    private <T> Comparator<T> comparator(final @NotNull Func<T> fun) {
        if (fun == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/SortOption.comparator must not be null");
        }
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return this.compareStatEntries(SortOption.this.getSelector().compute(fun.compute(o1)), SortOption.this.getSelector().compute(fun.compute(o2)), SortOption.this.isDescendingOrder());
            }

            private int compareStatEntries(StatEntry stat1, StatEntry stat2, boolean desc) {
                int result = stat1.compareTo(stat2);
                if (desc) {
                    result = -result;
                }
                return result;
            }
        };
    }

    public boolean orderByLine() {
        return this == SORT_BY_LINE || this == SORT_BY_LINE_DESC;
    }

    public boolean orderByStatement() {
        return this == SORT_BY_STATEMENT || this == SORT_BY_STATEMENT_DESC;
    }

    public boolean orderByMethod() {
        return this == SORT_BY_METHOD || this == SORT_BY_METHOD_DESC;
    }

    public boolean orderByClass() {
        return this == SORT_BY_CLASS || this == SORT_BY_CLASS_DESC;
    }

    public boolean orderByBlock() {
        return this == SORT_BY_BLOCK || this == SORT_BY_BLOCK_DESC;
    }

    public boolean orderByName() {
        return this == SORT_BY_NAME || this == SORT_BY_NAME_DESC;
    }

    public SortOption nextOrderByClass() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByClass() ? this.inverse() : SORT_BY_CLASS;
    }

    public SortOption nextOrderByName() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByName() ? this.inverse() : SORT_BY_NAME;
    }

    public SortOption nextOrderByLine() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByLine() ? this.inverse() : SORT_BY_LINE;
    }

    public SortOption nextOrderByStatement() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByStatement() ? this.inverse() : SORT_BY_STATEMENT;
    }

    public SortOption nextOrderByMethod() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByMethod() ? this.inverse() : SORT_BY_METHOD;
    }

    public SortOption nextOrderByBlock() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByBlock() ? this.inverse() : SORT_BY_BLOCK;
    }

    private static interface Selector {
        public StatEntry compute(@NotNull CoverageStatistics var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Func<T> {
        public CoverageStatistics compute(T var1);
    }
}

