/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import java.util.ArrayList;
import java.util.List;
import org.gradle.BuildExceptionReporter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.BuildResultLogger;
import org.gradle.StartParameter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.logging.StyledTextOutputFactory;

public class BuildLogger
implements BuildListener,
TaskExecutionGraphListener {
    private final Logger logger;
    private final List<BuildListener> resultLoggers = new ArrayList<BuildListener>();

    public BuildLogger(Logger logger, StyledTextOutputFactory textOutputFactory, StartParameter startParameter, BuildRequestMetaData requestMetaData) {
        this.logger = logger;
        this.resultLoggers.add(new BuildExceptionReporter(textOutputFactory, startParameter, requestMetaData.getClient()));
        this.resultLoggers.add(new BuildResultLogger(textOutputFactory, requestMetaData.getBuildTimeClock()));
    }

    public void buildStarted(Gradle gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        this.logger.info("Starting Build");
        this.logger.debug("Gradle user home: " + startParameter.getGradleUserHomeDir());
        this.logger.debug("Current dir: " + startParameter.getCurrentDir());
        this.logger.debug("Settings file: " + startParameter.getSettingsFile());
        this.logger.debug("Build file: " + startParameter.getBuildFile());
    }

    public void settingsEvaluated(Settings settings) {
        SettingsInternal settingsInternal = (SettingsInternal)settings;
        this.logger.info(String.format("Settings evaluated using %s.", settingsInternal.getSettingsScript().getDisplayName()));
    }

    public void projectsLoaded(Gradle gradle) {
        ProjectInternal projectInternal = (ProjectInternal)gradle.getRootProject();
        this.logger.info(String.format("Projects loaded. Root project using %s.", projectInternal.getBuildScriptSource().getDisplayName()));
        this.logger.info(String.format("Included projects: %s", projectInternal.getAllprojects()));
    }

    public void projectsEvaluated(Gradle gradle) {
        this.logger.info("All projects evaluated.");
    }

    public void graphPopulated(TaskExecutionGraph graph) {
        this.logger.info("Tasks to be executed: {}", graph.getAllTasks());
    }

    public void buildFinished(BuildResult result) {
        for (BuildListener logger : this.resultLoggers) {
            logger.buildFinished(result);
        }
    }
}

