/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.collections.BuildDependenciesOnlyFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFileCollection
extends AbstractFileCollection
implements FileCollectionContainer {
    @Override
    public Set<File> getFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (FileCollection fileCollection : this.getSourceCollections()) {
            files.addAll(fileCollection.getFiles());
        }
        return files;
    }

    @Override
    public boolean contains(File file) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (!fileCollection.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (fileCollection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            fileCollection.addToAntBuilder(builder, nodeName, FileCollection.AntType.ResourceCollection);
        }
    }

    @Override
    protected Collection<DirectoryFileTree> getAsFileTrees() {
        ArrayList<DirectoryFileTree> fileTree = new ArrayList<DirectoryFileTree>();
        for (FileCollection fileCollection : this.getSourceCollections()) {
            AbstractFileCollection collection = (AbstractFileCollection)fileCollection;
            fileTree.addAll(collection.getAsFileTrees());
        }
        return fileTree;
    }

    @Override
    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            public void resolve(FileCollectionResolveContext context) {
                ResolvableFileCollectionResolveContext nested = context.newContext();
                CompositeFileCollection.this.resolve(nested);
                context.add(nested.resolveAsFileTrees());
            }

            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }
        };
    }

    @Override
    public FileCollection filter(final Spec<? super File> filterSpec) {
        return new CompositeFileCollection(){

            public void resolve(FileCollectionResolveContext context) {
                for (FileCollection fileCollection : CompositeFileCollection.this.getSourceCollections()) {
                    context.add(fileCollection.filter((Spec<? super File>)filterSpec));
                }
            }

            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }

            public TaskDependency getBuildDependencies() {
                return CompositeFileCollection.this.getBuildDependencies();
            }
        };
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            public void resolve(TaskDependencyResolveContext context) {
                CompositeFileCollection.this.addDependencies(context);
            }
        };
    }

    protected void addDependencies(TaskDependencyResolveContext context) {
        BuildDependenciesOnlyFileCollectionResolveContext fileContext = new BuildDependenciesOnlyFileCollectionResolveContext();
        this.resolve(fileContext);
        for (Buildable buildable : fileContext.resolveAsBuildables()) {
            context.add(buildable);
        }
    }

    protected Collection<? extends FileCollectionInternal> getSourceCollections() {
        DefaultFileCollectionResolveContext context = new DefaultFileCollectionResolveContext();
        this.resolve(context);
        return context.resolveAsFileCollections();
    }

    @Override
    public abstract void resolve(FileCollectionResolveContext var1);

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        for (FileCollectionInternal fileCollectionInternal : this.getSourceCollections()) {
            fileCollectionInternal.registerWatchPoints(builder);
        }
    }
}

