/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderScope
implements ClassLoaderScope {
    public static final String STRICT_MODE_PROPERTY = "org.gradle.classloaderscope.strict";
    final ClassLoaderScopeIdentifier id;
    private final ClassLoaderScope parent;
    private final ClassLoaderCache classLoaderCache;
    private boolean locked;
    private ClassPath export = new DefaultClassPath(new File[0]);
    private ClassPath local = new DefaultClassPath(new File[0]);
    private List<ClassLoader> ownLoaders = new ArrayList<ClassLoader>();
    private MultiParentClassLoader exportingClassLoader;
    private MultiParentClassLoader localClassLoader;
    private ClassLoader effectiveLocalClassLoader;
    private ClassLoader effectiveExportClassLoader;

    public DefaultClassLoaderScope(ClassLoaderScopeIdentifier id, ClassLoaderScope parent, ClassLoaderCache classLoaderCache) {
        this.id = id;
        this.parent = parent;
        this.classLoaderCache = classLoaderCache;
    }

    private ClassLoader buildLockedLoader(ClassLoaderId id, ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this.parent.getExportClassLoader();
        }
        return this.loader(id, classPath);
    }

    private ClassLoader buildLockedLoader(ClassLoaderId id, ClassLoader additional, ClassPath classPath) {
        if (classPath.isEmpty()) {
            return additional;
        }
        return new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{additional, this.loader(id, classPath)}));
    }

    private void buildEffectiveLoaders() {
        if (this.effectiveLocalClassLoader == null) {
            if (this.locked) {
                if (this.local.isEmpty() && this.export.isEmpty()) {
                    this.classLoaderCache.remove(this.id.localId());
                    this.classLoaderCache.remove(this.id.exportId());
                    this.effectiveLocalClassLoader = this.parent.getExportClassLoader();
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                } else if (this.export.isEmpty()) {
                    this.classLoaderCache.remove(this.id.exportId());
                    this.effectiveLocalClassLoader = this.buildLockedLoader(this.id.localId(), this.local);
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                } else if (this.local.isEmpty()) {
                    this.classLoaderCache.remove(this.id.localId());
                    this.effectiveExportClassLoader = this.effectiveLocalClassLoader = this.buildLockedLoader(this.id.exportId(), this.export);
                } else {
                    this.effectiveExportClassLoader = this.buildLockedLoader(this.id.exportId(), this.export);
                    this.effectiveLocalClassLoader = this.buildLockedLoader(this.id.localId(), this.effectiveExportClassLoader, this.local);
                }
            } else {
                if (Boolean.getBoolean(STRICT_MODE_PROPERTY)) {
                    throw new IllegalStateException("Attempt to define scope class loader before scope is locked");
                }
                this.exportingClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.parent.getExportClassLoader(), this.loader(this.id.exportId(), this.export)});
                this.effectiveExportClassLoader = new CachingClassLoader((ClassLoader)this.exportingClassLoader);
                this.localClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.effectiveExportClassLoader, this.loader(this.id.localId(), this.local)});
                this.effectiveLocalClassLoader = new CachingClassLoader((ClassLoader)this.localClassLoader);
            }
            this.export = null;
            this.local = null;
        }
    }

    @Override
    public ClassLoader getExportClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveExportClassLoader;
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveLocalClassLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this.parent;
    }

    @Override
    public boolean defines(Class<?> clazz) {
        for (ClassLoader ownLoader : this.ownLoaders) {
            if (!ownLoader.equals(clazz.getClassLoader())) continue;
            return true;
        }
        return false;
    }

    private ClassLoader loader(ClassLoaderId id, ClassPath classPath) {
        ClassLoader classLoader = this.classLoaderCache.get(id, classPath, this.parent.getExportClassLoader(), null);
        this.ownLoaders.add(classLoader);
        return classLoader;
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this;
        }
        this.assertNotLocked();
        if (this.localClassLoader != null) {
            ClassLoader loader = this.loader(this.id.localId(), classPath);
            this.localClassLoader.addParent(loader);
        } else {
            this.local = this.local.plus(classPath);
        }
        return this;
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this;
        }
        this.assertNotLocked();
        if (this.exportingClassLoader != null) {
            this.exportingClassLoader.addParent(this.loader(this.id.exportId(), classPath));
        } else {
            this.export = this.export.plus(classPath);
        }
        return this;
    }

    private void assertNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("class loader scope is locked");
        }
    }

    @Override
    public ClassLoaderScope createChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException("'name' cannot be null");
        }
        return new DefaultClassLoaderScope(this.id.child(name), this, this.classLoaderCache);
    }

    @Override
    public ClassLoaderScope lock() {
        this.locked = true;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }
}

