/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.execution.internal.InternalTaskExecutionListener;
import org.gradle.api.execution.internal.TaskOperationInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskExecutionContext;
import org.gradle.api.specs.Spec;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.execution.taskgraph.DefaultTaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.progress.OperationIdGenerator;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskGraphExecuter
implements TaskGraphExecuter {
    private static Logger logger = LoggerFactory.getLogger(DefaultTaskGraphExecuter.class);
    private final TaskPlanExecutor taskPlanExecutor;
    private final Factory<? extends TaskExecuter> taskExecuter;
    private final TimeProvider timeProvider;
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final ListenerBroadcast<InternalTaskExecutionListener> internalTaskListeners;
    private final DefaultTaskExecutionPlan taskExecutionPlan;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Object eventNotificationLock = new Object();
    private TaskGraphState taskGraphState = TaskGraphState.EMPTY;

    public DefaultTaskGraphExecuter(ListenerManager listenerManager, TaskPlanExecutor taskPlanExecutor, Factory<? extends TaskExecuter> taskExecuter, BuildCancellationToken cancellationToken, TimeProvider timeProvider, BuildOperationExecutor buildOperationExecutor) {
        this.taskPlanExecutor = taskPlanExecutor;
        this.taskExecuter = taskExecuter;
        this.timeProvider = timeProvider;
        this.buildOperationExecutor = buildOperationExecutor;
        this.graphListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionGraphListener.class);
        this.taskListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionListener.class);
        this.internalTaskListeners = listenerManager.createAnonymousBroadcaster(InternalTaskExecutionListener.class);
        this.taskExecutionPlan = new DefaultTaskExecutionPlan(cancellationToken);
    }

    @Override
    public void useFailureHandler(TaskFailureHandler handler) {
        this.taskExecutionPlan.useFailureHandler(handler);
    }

    @Override
    public void useFilter(Spec<? super Task> filter) {
        this.taskExecutionPlan.useFilter(filter);
        this.taskGraphState = TaskGraphState.DIRTY;
    }

    @Override
    public void addTasks(Iterable<? extends Task> tasks) {
        assert (tasks != null);
        Clock clock = new Clock();
        LinkedHashSet<Task> taskSet = new LinkedHashSet<Task>();
        for (Task task : tasks) {
            taskSet.add(task);
        }
        this.taskExecutionPlan.addToTaskGraph(taskSet);
        this.taskGraphState = TaskGraphState.DIRTY;
        logger.debug("Timing: Creating the DAG took " + clock.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Clock clock = new Clock();
        this.ensurePopulated();
        ((TaskExecutionGraphListener)this.graphListeners.getSource()).graphPopulated(this);
        try {
            this.taskPlanExecutor.process(this.taskExecutionPlan, new EventFiringTaskWorker((TaskExecuter)this.taskExecuter.create()));
            logger.debug("Timing: Executing the DAG took " + clock.getTime());
        }
        finally {
            this.taskExecutionPlan.clear();
        }
    }

    @Override
    public void addTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.add((Object)listener);
    }

    @Override
    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.remove((Object)listener);
    }

    @Override
    public void whenReady(Closure closure) {
        this.graphListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("graphPopulated", closure));
    }

    @Override
    public void addTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.add((Object)listener);
    }

    @Override
    public void removeTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.remove((Object)listener);
    }

    @Override
    public void beforeTask(Closure closure) {
        this.taskListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeExecute", closure));
    }

    @Override
    public void afterTask(Closure closure) {
        this.taskListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterExecute", closure));
    }

    @Override
    public boolean hasTask(Task task) {
        this.ensurePopulated();
        return this.taskExecutionPlan.getTasks().contains(task);
    }

    @Override
    public boolean hasTask(String path) {
        this.ensurePopulated();
        assert (path != null && path.length() > 0);
        for (Task task : this.taskExecutionPlan.getTasks()) {
            if (!task.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Task> getAllTasks() {
        this.ensurePopulated();
        return this.taskExecutionPlan.getTasks();
    }

    private void ensurePopulated() {
        switch (this.taskGraphState) {
            case EMPTY: {
                throw new IllegalStateException("Task information is not available, as this task execution graph has not been populated.");
            }
            case DIRTY: {
                this.taskExecutionPlan.determineExecutionPlan();
                this.taskGraphState = TaskGraphState.POPULATED;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventFiringTaskWorker
    implements Action<TaskInternal> {
        private final TaskExecuter taskExecuter;

        public EventFiringTaskWorker(TaskExecuter taskExecuter) {
            this.taskExecuter = taskExecuter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(TaskInternal task) {
            Object id = OperationIdGenerator.generateId(task);
            Object parentId = DefaultTaskGraphExecuter.this.buildOperationExecutor.getCurrentOperationId();
            TaskOperationInternal taskOperation = new TaskOperationInternal(id, parentId, task);
            TaskStateInternal state = task.getState();
            long startTime = DefaultTaskGraphExecuter.this.timeProvider.getCurrentTime();
            Object object = DefaultTaskGraphExecuter.this.eventNotificationLock;
            synchronized (object) {
                ((InternalTaskExecutionListener)DefaultTaskGraphExecuter.this.internalTaskListeners.getSource()).beforeExecute(taskOperation, new OperationStartEvent(startTime));
            }
            try {
                object = DefaultTaskGraphExecuter.this.eventNotificationLock;
                synchronized (object) {
                    ((TaskExecutionListener)DefaultTaskGraphExecuter.this.taskListeners.getSource()).beforeExecute(task);
                }
                this.taskExecuter.execute(task, task.getState(), new DefaultTaskExecutionContext());
                object = DefaultTaskGraphExecuter.this.eventNotificationLock;
                synchronized (object) {
                    ((TaskExecutionListener)DefaultTaskGraphExecuter.this.taskListeners.getSource()).afterExecute(task, state);
                }
            }
            finally {
                object = DefaultTaskGraphExecuter.this.eventNotificationLock;
                synchronized (object) {
                    long endTime = DefaultTaskGraphExecuter.this.timeProvider.getCurrentTime();
                    ((InternalTaskExecutionListener)DefaultTaskGraphExecuter.this.internalTaskListeners.getSource()).afterExecute(taskOperation, new OperationResult(startTime, endTime, task.getState().getFailure()));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskGraphState {
        EMPTY,
        DIRTY,
        POPULATED;

    }
}

