/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.Script;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.configuration.ImportsReader;
import org.gradle.groovy.scripts.ScriptCompilationException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ClassCachingCompiledScript;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.EmptyScriptGenerator;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.util.Clock;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptCompilationHandler
implements ScriptCompilationHandler {
    private Logger logger = LoggerFactory.getLogger(DefaultScriptCompilationHandler.class);
    private static final NoOpGroovyResourceLoader NO_OP_GROOVY_RESOURCE_LOADER = new NoOpGroovyResourceLoader();
    private static final String EMPTY_SCRIPT_MARKER_FILE_NAME = "emptyScript.txt";
    private static final String METADATA_FILE_NAME = "metadata.bin";
    private final EmptyScriptGenerator emptyScriptGenerator;
    private final ClassLoaderCache classLoaderCache;
    private final String[] defaultImportPackages;

    public DefaultScriptCompilationHandler(EmptyScriptGenerator emptyScriptGenerator, ClassLoaderCache classLoaderCache, ImportsReader importsReader) {
        this.emptyScriptGenerator = emptyScriptGenerator;
        this.classLoaderCache = classLoaderCache;
        this.defaultImportPackages = importsReader.getImportPackages();
    }

    @Override
    public void compileToDir(ScriptSource source, ClassLoader classLoader, File classesDir, File metadataDir, CompileOperation<?> extractingTransformer, String classpathClosureName, Class<? extends Script> scriptBaseClass, Action<? super ClassNode> verifier) {
        Clock clock = new Clock();
        GFileUtils.deleteDirectory(classesDir);
        GFileUtils.mkdirs(classesDir);
        CompilerConfiguration configuration = this.createBaseCompilerConfiguration(scriptBaseClass);
        configuration.setTargetDirectory(classesDir);
        try {
            this.compileScript(source, classLoader, configuration, classesDir, metadataDir, extractingTransformer, verifier, classpathClosureName);
        }
        catch (GradleException e) {
            GFileUtils.deleteDirectory(classesDir);
            throw e;
        }
        this.logger.debug("Timing: Writing script to cache at {} took: {}", (Object)classesDir.getAbsolutePath(), (Object)clock.getTime());
    }

    private void compileScript(final ScriptSource source, ClassLoader classLoader, CompilerConfiguration configuration, File classesDir, File metadataDir, CompileOperation<?> extractingTransformer, final Action<? super ClassNode> customVerifier, String classpathClosureName) {
        final Transformer transformer = extractingTransformer != null ? extractingTransformer.getTransformer() : null;
        this.logger.info("Compiling {} using {}.", (Object)source.getDisplayName(), (Object)(transformer != null ? transformer.getClass().getSimpleName() : "no transformer"));
        final EmptyScriptDetector emptyScriptDetector = new EmptyScriptDetector();
        final PackageStatementDetector packageDetector = new PackageStatementDetector();
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader, configuration, false){

            protected CompilationUnit createCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource) {
                ImportCustomizer customizer = new ImportCustomizer();
                customizer.addStarImports(DefaultScriptCompilationHandler.this.defaultImportPackages);
                compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
                CustomCompilationUnit compilationUnit = new CustomCompilationUnit(compilerConfiguration, codeSource, (Action<? super ClassNode>)customVerifier, source, this);
                if (transformer != null) {
                    transformer.register((CompilationUnit)compilationUnit);
                }
                compilationUnit.addPhaseOperation(packageDetector, 5);
                compilationUnit.addPhaseOperation(emptyScriptDetector, 5);
                return compilationUnit;
            }
        };
        groovyClassLoader.setResourceLoader((GroovyResourceLoader)NO_OP_GROOVY_RESOURCE_LOADER);
        String scriptText = source.getResource().getText();
        String scriptName = source.getClassName();
        GroovyCodeSource codeSource = new GroovyCodeSource(scriptText == null ? "" : scriptText, scriptName, "/groovy/script");
        try {
            groovyClassLoader.parseClass(codeSource, false);
        }
        catch (MultipleCompilationErrorsException e) {
            this.wrapCompilationFailure(source, e);
        }
        catch (CompilationFailedException e) {
            throw new GradleException(String.format("Could not compile %s.", source.getDisplayName()), (Throwable)e);
        }
        if (packageDetector.hasPackageStatement) {
            throw new UnsupportedOperationException(String.format("%s should not contain a package statement.", StringUtils.capitalize((String)source.getDisplayName())));
        }
        if (emptyScriptDetector.isEmptyScript()) {
            GFileUtils.touch(new File(classesDir, EMPTY_SCRIPT_MARKER_FILE_NAME));
        }
        this.serializeMetadata(source, extractingTransformer, metadataDir);
    }

    private <M> void serializeMetadata(ScriptSource scriptSource, CompileOperation<M> extractingTransformer, File metadataDir) {
        FileOutputStream outputStream;
        if (extractingTransformer == null || extractingTransformer.getDataSerializer() == null) {
            return;
        }
        GFileUtils.mkdirs(metadataDir);
        File metadataFile = new File(metadataDir, METADATA_FILE_NAME);
        try {
            outputStream = new FileOutputStream(metadataFile);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException("Could not create or open build script metadata file " + metadataFile.getAbsolutePath(), (Throwable)e);
        }
        KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)outputStream);
        Serializer<M> serializer = extractingTransformer.getDataSerializer();
        try {
            serializer.write((Encoder)encoder, extractingTransformer.getExtractedData());
        }
        catch (Exception e) {
            String transformerName = extractingTransformer.getTransformer().getClass().getName();
            throw new IllegalStateException(String.format("Failed to serialize script metadata extracted using %s for %s", transformerName, scriptSource.getDisplayName()), e);
        }
        finally {
            encoder.close();
        }
    }

    private void wrapCompilationFailure(ScriptSource source, MultipleCompilationErrorsException e) {
        for (Object message : e.getErrorCollector().getErrors()) {
            if (!(message instanceof SyntaxErrorMessage)) continue;
            try {
                SyntaxErrorMessage syntaxErrorMessage = (SyntaxErrorMessage)message;
                Field sourceField = SyntaxErrorMessage.class.getDeclaredField("source");
                sourceField.setAccessible(true);
                SourceUnit sourceUnit = (SourceUnit)sourceField.get(syntaxErrorMessage);
                Field nameField = SourceUnit.class.getDeclaredField("name");
                nameField.setAccessible(true);
                nameField.set(sourceUnit, source.getDisplayName());
            }
            catch (Exception failure) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }
        }
        SyntaxException syntaxError = e.getErrorCollector().getSyntaxError(0);
        Integer lineNumber = syntaxError == null ? null : Integer.valueOf(syntaxError.getLine());
        throw new ScriptCompilationException(String.format("Could not compile %s.", source.getDisplayName()), e, source, lineNumber);
    }

    private CompilerConfiguration createBaseCompilerConfiguration(Class<? extends Script> scriptBaseClass) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setScriptBaseClass(scriptBaseClass.getName());
        return configuration;
    }

    @Override
    public <T extends Script, M> CompiledScript<T, M> loadFromDir(final ScriptSource source, final ClassLoader classLoader, final File scriptCacheDir, File metadataCacheDir, CompileOperation<M> transformer, final Class<T> scriptBaseClass, final ClassLoaderId classLoaderId) {
        final M metadata = this.deserializeMetadata(source, transformer, metadataCacheDir);
        return new ClassCachingCompiledScript(new CompiledScript<T, M>(){

            @Override
            public Class<? extends T> loadClass() {
                if (new File(scriptCacheDir, DefaultScriptCompilationHandler.EMPTY_SCRIPT_MARKER_FILE_NAME).isFile()) {
                    DefaultScriptCompilationHandler.this.classLoaderCache.remove(classLoaderId);
                    return DefaultScriptCompilationHandler.this.emptyScriptGenerator.generate(scriptBaseClass);
                }
                try {
                    ClassLoader loader = DefaultScriptCompilationHandler.this.classLoaderCache.get(classLoaderId, (ClassPath)new DefaultClassPath(new File[]{scriptCacheDir}), classLoader, null);
                    return loader.loadClass(source.getClassName()).asSubclass(scriptBaseClass);
                }
                catch (Exception e) {
                    File expectedClassFile = new File(scriptCacheDir, source.getClassName() + ".class");
                    if (!expectedClassFile.exists()) {
                        throw new GradleException(String.format("Could not load compiled classes for %s from cache. Expected class file %s does not exist.", source.getDisplayName(), expectedClassFile.getAbsolutePath()), (Throwable)e);
                    }
                    throw new GradleException(String.format("Could not load compiled classes for %s from cache.", source.getDisplayName()), (Throwable)e);
                }
            }

            @Override
            public M getData() {
                return metadata;
            }
        });
    }

    private <M> M deserializeMetadata(ScriptSource scriptSource, CompileOperation<M> extractingTransformer, File metadataCacheDir) {
        FileInputStream inputStream;
        if (extractingTransformer == null || extractingTransformer.getDataSerializer() == null) {
            return null;
        }
        File metadataFile = new File(metadataCacheDir, METADATA_FILE_NAME);
        try {
            inputStream = new FileInputStream(metadataFile);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException("Could not open build script metadata file " + metadataFile.getAbsolutePath(), (Throwable)e);
        }
        KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)inputStream);
        Serializer<M> serializer = extractingTransformer.getDataSerializer();
        try {
            Object object = serializer.read((Decoder)decoder);
            return (M)object;
        }
        catch (Exception e) {
            String transformerName = extractingTransformer.getTransformer().getClass().getName();
            throw new IllegalStateException(String.format("Failed to deserialize script metadata extracted using %s for %s", transformerName, scriptSource.getDisplayName()), e);
        }
        finally {
            try {
                decoder.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close script metadata file decoder backed by " + metadataFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomCompilationUnit
    extends CompilationUnit {
        private final ScriptSource source;

        public CustomCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource, final Action<? super ClassNode> customVerifier, ScriptSource source, GroovyClassLoader groovyClassLoader) {
            super(compilerConfiguration, codeSource, groovyClassLoader);
            this.source = source;
            this.verifier = new Verifier(){

                public void visitClass(ClassNode node) {
                    customVerifier.execute((Object)node);
                    super.visitClass(node);
                }
            };
        }

        protected ClassVisitor createClassVisitor() {
            return new ClassWriter(1){

                public byte[] toByteArray() {
                    this.visitSource(CustomCompilationUnit.this.source.getFileName(), null);
                    return super.toByteArray();
                }
            };
        }
    }

    private static class NoOpGroovyResourceLoader
    implements GroovyResourceLoader {
        private NoOpGroovyResourceLoader() {
        }

        public URL loadGroovySource(String filename) throws MalformedURLException {
            return null;
        }
    }

    private static class EmptyScriptDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean emptyScript;

        private EmptyScriptDetector() {
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            this.emptyScript = this.isEmpty(source);
        }

        private boolean isEmpty(SourceUnit source) {
            if (!source.getAST().getMethods().isEmpty()) {
                return false;
            }
            List statements = source.getAST().getStatementBlock().getStatements();
            if (statements.size() > 1) {
                return false;
            }
            if (statements.isEmpty()) {
                return true;
            }
            return AstUtils.isReturnNullStatement((Statement)((Statement)statements.get(0)));
        }

        public boolean isEmptyScript() {
            return this.emptyScript;
        }
    }

    private static class PackageStatementDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean hasPackageStatement;

        private PackageStatementDetector() {
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            this.hasPackageStatement = source.getAST().getPackageName() != null;
        }
    }
}

