/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgGraftCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCherryPicker
extends VcsCherryPicker {
    @NotNull
    private final Project myProject;

    public HgCherryPicker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/cherrypick/HgCherryPicker", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = HgVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/cherrypick/HgCherryPicker", "getSupportedVcs"));
        }
        return vcsKey;
    }

    @NotNull
    public String getActionTitle() {
        if ("Graft" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/cherrypick/HgCherryPicker", "getActionTitle"));
        }
        return "Graft";
    }

    public void cherryPick(@NotNull List<VcsFullCommitDetails> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "org/zmlx/hg4idea/cherrypick/HgCherryPicker", "cherryPick"));
        }
        Map commitsInRoots = DvcsUtil.groupCommitsByRoots((RepositoryManager)HgUtil.getRepositoryManager(this.myProject), commits);
        for (Map.Entry entry : commitsInRoots.entrySet()) {
            HgCherryPicker.processGrafting((HgRepository)entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), (Function)new Function<VcsFullCommitDetails, String>(){

                public String fun(VcsFullCommitDetails commitDetails) {
                    return ((Hash)commitDetails.getId()).asString();
                }
            }));
        }
    }

    private static void processGrafting(@NotNull HgRepository repository, @NotNull List<String> hashes) {
        boolean hasConflicts;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/cherrypick/HgCherryPicker", "processGrafting"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "org/zmlx/hg4idea/cherrypick/HgCherryPicker", "processGrafting"));
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        HgGraftCommand command = new HgGraftCommand(project, repository);
        HgCommandResult result = command.startGrafting(hashes);
        boolean bl = hasConflicts = !HgConflictResolver.findConflicts(project, root).isEmpty();
        if (!hasConflicts && HgErrorUtil.isCommandExecutionFailed(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't  graft.");
            return;
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        while (hasConflicts) {
            new HgConflictResolver(project, updatedFiles).resolve(root);
            boolean bl2 = hasConflicts = !HgConflictResolver.findConflicts(project, root).isEmpty();
            if (!hasConflicts) {
                result = command.continueGrafting();
                hasConflicts = !HgConflictResolver.findConflicts(project, root).isEmpty();
                continue;
            }
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't continue grafting");
            break;
        }
        repository.update();
        root.refresh(true, true);
    }

    public boolean isEnabled(@NotNull VcsLog log, @NotNull List<VcsFullCommitDetails> details) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "org/zmlx/hg4idea/cherrypick/HgCherryPicker", "isEnabled"));
        }
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "org/zmlx/hg4idea/cherrypick/HgCherryPicker", "isEnabled"));
        }
        if (details.isEmpty()) {
            return false;
        }
        for (VcsFullCommitDetails commit : details) {
            HgRepository repository = (HgRepository)HgUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(commit.getRoot());
            if (repository != null) continue;
            return false;
        }
        return true;
    }
}

