/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.util.ArrayList;
import java.util.List;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSummary;
import org.apache.sanselan.util.Debug;

public final class TiffOutputSet
implements TiffConstants {
    public final int byteOrder;
    private final ArrayList directories = new ArrayList();
    private static final String newline = System.getProperty("line.separator");

    public TiffOutputSet() {
        this(73);
    }

    public TiffOutputSet(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    protected List getOutputItems(TiffOutputSummary outputSummary) throws ImageWriteException {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffOutputDirectory directory = (TiffOutputDirectory)this.directories.get(i);
            result.addAll(directory.getOutputItems(outputSummary));
        }
        return result;
    }

    public void addDirectory(TiffOutputDirectory directory) throws ImageWriteException {
        if (null != this.findDirectory(directory.type)) {
            throw new ImageWriteException("Output set already contains a directory of that type.");
        }
        this.directories.add(directory);
    }

    public List getDirectories() {
        return new ArrayList(this.directories);
    }

    public TiffOutputDirectory getRootDirectory() {
        return this.findDirectory(0);
    }

    public TiffOutputDirectory getExifDirectory() {
        return this.findDirectory(-2);
    }

    public TiffOutputDirectory getOrCreateRootDirectory() throws ImageWriteException {
        TiffOutputDirectory result = this.findDirectory(0);
        if (null != result) {
            return result;
        }
        return this.addRootDirectory();
    }

    public TiffOutputDirectory getOrCreateExifDirectory() throws ImageWriteException {
        this.getOrCreateRootDirectory();
        TiffOutputDirectory result = this.findDirectory(-2);
        if (null != result) {
            return result;
        }
        return this.addExifDirectory();
    }

    public TiffOutputDirectory getOrCreateGPSDirectory() throws ImageWriteException {
        this.getOrCreateExifDirectory();
        TiffOutputDirectory result = this.findDirectory(-3);
        if (null != result) {
            return result;
        }
        return this.addGPSDirectory();
    }

    public TiffOutputDirectory getGPSDirectory() {
        return this.findDirectory(-3);
    }

    public TiffOutputDirectory getInteroperabilityDirectory() {
        return this.findDirectory(-4);
    }

    public TiffOutputDirectory findDirectory(int directoryType) {
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffOutputDirectory directory = (TiffOutputDirectory)this.directories.get(i);
            if (directory.type != directoryType) continue;
            return directory;
        }
        return null;
    }

    public void setGPSInDegrees(double longitude, double latitude) throws ImageWriteException {
        TiffOutputDirectory gpsDirectory = this.getOrCreateGPSDirectory();
        String longitudeRef = longitude < 0.0 ? "W" : "E";
        longitude = Math.abs(longitude);
        String latitudeRef = latitude < 0.0 ? "S" : "N";
        latitude = Math.abs(latitude);
        TiffOutputField longitudeRefField = TiffOutputField.create(TiffConstants.GPS_TAG_GPS_LONGITUDE_REF, this.byteOrder, longitudeRef);
        gpsDirectory.removeField(TiffConstants.GPS_TAG_GPS_LONGITUDE_REF);
        gpsDirectory.add(longitudeRefField);
        TiffOutputField latitudeRefField = TiffOutputField.create(TiffConstants.GPS_TAG_GPS_LATITUDE_REF, this.byteOrder, latitudeRef);
        gpsDirectory.removeField(TiffConstants.GPS_TAG_GPS_LATITUDE_REF);
        gpsDirectory.add(latitudeRefField);
        double value = longitude;
        double longitudeDegrees = (long)value;
        value %= 1.0;
        double longitudeMinutes = (long)(value *= 60.0);
        value %= 1.0;
        double longitudeSeconds = value *= 60.0;
        Number[] values = new Double[]{new Double(longitudeDegrees), new Double(longitudeMinutes), new Double(longitudeSeconds)};
        TiffOutputField longitudeField = TiffOutputField.create(TiffConstants.GPS_TAG_GPS_LONGITUDE, this.byteOrder, values);
        gpsDirectory.removeField(TiffConstants.GPS_TAG_GPS_LONGITUDE);
        gpsDirectory.add(longitudeField);
        value = latitude;
        double latitudeDegrees = (long)value;
        value %= 1.0;
        double latitudeMinutes = (long)(value *= 60.0);
        value %= 1.0;
        double latitudeSeconds = value *= 60.0;
        values = new Double[]{new Double(latitudeDegrees), new Double(latitudeMinutes), new Double(latitudeSeconds)};
        TiffOutputField latitudeField = TiffOutputField.create(TiffConstants.GPS_TAG_GPS_LATITUDE, this.byteOrder, values);
        gpsDirectory.removeField(TiffConstants.GPS_TAG_GPS_LATITUDE);
        gpsDirectory.add(latitudeField);
    }

    public void removeField(TagInfo tagInfo) {
        this.removeField(tagInfo.tag);
    }

    public void removeField(int tag) {
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffOutputDirectory directory = (TiffOutputDirectory)this.directories.get(i);
            directory.removeField(tag);
        }
    }

    public TiffOutputField findField(TagInfo tagInfo) {
        return this.findField(tagInfo.tag);
    }

    public TiffOutputField findField(int tag) {
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffOutputDirectory directory = (TiffOutputDirectory)this.directories.get(i);
            TiffOutputField field = directory.findField(tag);
            if (null == field) continue;
            return field;
        }
        return null;
    }

    public TiffOutputDirectory addRootDirectory() throws ImageWriteException {
        TiffOutputDirectory result = new TiffOutputDirectory(0);
        this.addDirectory(result);
        return result;
    }

    public TiffOutputDirectory addExifDirectory() throws ImageWriteException {
        TiffOutputDirectory result = new TiffOutputDirectory(-2);
        this.addDirectory(result);
        return result;
    }

    public TiffOutputDirectory addGPSDirectory() throws ImageWriteException {
        TiffOutputDirectory result = new TiffOutputDirectory(-3);
        this.addDirectory(result);
        return result;
    }

    public TiffOutputDirectory addInteroperabilityDirectory() throws ImageWriteException {
        this.getOrCreateExifDirectory();
        TiffOutputDirectory result = new TiffOutputDirectory(-4);
        this.addDirectory(result);
        return result;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        StringBuffer result = new StringBuffer();
        result.append(prefix);
        result.append("TiffOutputSet {");
        result.append(newline);
        result.append(prefix);
        result.append("byteOrder: " + this.byteOrder);
        result.append(newline);
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffOutputDirectory directory = (TiffOutputDirectory)this.directories.get(i);
            result.append(prefix);
            result.append("\tdirectory " + i + ": " + directory.description() + " (" + directory.type + ")");
            result.append(newline);
            ArrayList fields = directory.getFields();
            for (int j = 0; j < fields.size(); ++j) {
                TiffOutputField field = (TiffOutputField)fields.get(j);
                result.append(prefix);
                result.append("\t\tfield " + i + ": " + field.tagInfo);
                result.append(newline);
            }
        }
        result.append(prefix);
        result.append("}");
        result.append(newline);
        return result.toString();
    }

    public void dump() {
        Debug.debug(this.toString());
    }
}

