/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.uiDesigner.DesignSpacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;

public final class HSpacer
extends DesignSpacer {
    public HSpacer() {
        this.setSize(50, HSpacer.getHandleHeight());
    }

    protected void paintComponent(Graphics g) {
        int handleHeight = HSpacer.getHandleHeight();
        int handleWidth = HSpacer.getHandleWidth();
        int y = (this.getHeight() - handleHeight) / 2;
        HSpacer.drawHandle(g, 0, y);
        g.setColor(ourColor1);
        UIUtil.drawLine((Graphics)g, (int)handleWidth, (int)(y + handleHeight / 2), (int)(handleWidth + 1), (int)(y + handleHeight / 2));
        int x = this.getWidth() - handleWidth - 1;
        HSpacer.drawHandle(g, x, y);
        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + handleHeight / 2), (int)(x - 2), (int)(y + handleHeight / 2));
        g.setColor(ourColor1);
        HSpacer.drawSpring(g, handleWidth + 1, y + handleHeight / 2, this.getWidth() - 2 * handleWidth - 4);
    }

    private static int getHandleWidth() {
        return 5;
    }

    private static int getHandleHeight() {
        return 11;
    }

    private static void drawHandle(Graphics g, int x, int y) {
        g.setColor(ourColor1);
        g.drawRect(x, y, 4, 2);
        UIUtil.drawLine((Graphics)g, (int)(x + 2), (int)(y + 3), (int)(x + 2), (int)(y + 3 + 1 - 1));
        g.drawRect(x, y += 4, 4, 2);
        UIUtil.drawLine((Graphics)g, (int)(x + 2), (int)(y + 3), (int)(x + 2), (int)(y + 3 + 1 - 1));
        g.drawRect(x, y += 4, 4, 2);
    }

    private static void drawSpring(Graphics g, int x, int y, int width) {
        for (int _x = x; _x < x + width - 1; _x += 4) {
            HSpacer.drawSpringPeriod(g, _x, y);
        }
    }

    private static void drawSpringPeriod(Graphics g, int x, int y) {
        g.setColor(ourColor2);
        UIUtil.drawLine((Graphics)g, (int)x, (int)(y - 1), (int)x, (int)(y - 2));
        UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)y, (int)(x + 1), (int)y);
        UIUtil.drawLine((Graphics)g, (int)(x + 2), (int)(y + 1), (int)(x + 2), (int)(y + 2));
        g.setColor(ourColor3);
        UIUtil.drawLine((Graphics)g, (int)(x + 3), (int)y, (int)(x + 3), (int)y);
    }

    public Dimension getMinimumSize() {
        return new Dimension(HSpacer.getHandleWidth() * 2 + 4, HSpacer.getHandleHeight());
    }
}

