/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.actions.TargetAction;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.StringSetSpinAllocator;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AntBuildGroup
extends ActionGroup
implements DumbAware {
    public void update(AnActionEvent event) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(project != null);
        presentation.setVisible(project != null);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/actions/AntBuildGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/actions/AntBuildGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        ArrayList<DefaultActionGroup> children = new ArrayList<DefaultActionGroup>();
        AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(project);
        for (AntBuildFileBase buildFile : antConfiguration.getBuildFiles()) {
            String name = buildFile.getPresentableName();
            DefaultActionGroup subgroup = new DefaultActionGroup();
            subgroup.getTemplatePresentation().setText(name, false);
            subgroup.setPopup(true);
            AntBuildGroup.fillGroup(buildFile, subgroup, antConfiguration);
            if (subgroup.getChildrenCount() <= 0) continue;
            children.add(subgroup);
        }
        AnAction[] anActionArray = children.toArray(new AnAction[children.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/actions/AntBuildGroup", "getChildren"));
        }
        return anActionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillGroup(AntBuildFile buildFile, DefaultActionGroup group, AntConfiguration antConfiguration) {
        AntBuildModelBase model = (AntBuildModelBase)buildFile.getModel();
        if (model.getDefaultTargetName() != null) {
            DefaultActionGroup subgroup = new DefaultActionGroup();
            subgroup.add(AntBuildGroup.getOrCreateAction(buildFile, TargetAction.DEFAULT_TARGET_NAME, new String[]{TargetAction.DEFAULT_TARGET_NAME}, null, model.getDefaultTargetActionId()));
            group.add((AnAction)subgroup);
        }
        Set addedTargetNames = StringSetSpinAllocator.alloc();
        try {
            AntBuildGroup.addGroupOfTargets(buildFile, model.getFilteredTargets(), addedTargetNames, group);
            AntBuildGroup.addGroupOfTargets(buildFile, antConfiguration.getMetaTargets(buildFile), addedTargetNames, group);
        }
        finally {
            StringSetSpinAllocator.dispose((Set)addedTargetNames);
        }
    }

    private static void addGroupOfTargets(AntBuildFile buildFile, AntBuildTarget[] targets, Set<String> addedTargetNames, DefaultActionGroup group) {
        DefaultActionGroup subgroup = new DefaultActionGroup();
        for (AntBuildTarget target : targets) {
            String[] stringArray;
            String displayName = target.getName();
            if (addedTargetNames.contains(displayName)) continue;
            addedTargetNames.add(displayName);
            if (target instanceof MetaTarget) {
                stringArray = ((MetaTarget)target).getTargetNames();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = displayName;
            }
            String[] targetsToRun = stringArray;
            subgroup.add(AntBuildGroup.getOrCreateAction(buildFile, displayName, targetsToRun, target.getNotEmptyDescription(), ((AntBuildTargetBase)target).getActionId()));
        }
        if (subgroup.getChildrenCount() > 0) {
            group.add((AnAction)subgroup);
        }
    }

    private static AnAction getOrCreateAction(AntBuildFile buildFile, String displayName, String[] targets, String targetDescription, String actionId) {
        Object action = null;
        if (actionId != null) {
            action = ActionManager.getInstance().getAction(actionId);
        }
        if (action == null) {
            action = new TargetAction(buildFile, displayName, targets, targetDescription);
        }
        return action;
    }
}

